/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp.r;

import fi.csc.microarray.comp.CompJob;
import fi.csc.microarray.comp.JobCancelledException;
import fi.csc.microarray.comp.OnDiskCompJobBase;
import fi.csc.microarray.comp.ProcessPool;
import fi.csc.microarray.comp.ToolDescription;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

public class RCompJob
extends OnDiskCompJobBase {
    public static final String STRING_DELIMETER = "\"";
    public static RParameterSecurityPolicy R_PARAMETER_SECURITY_POLICY = new RParameterSecurityPolicy();
    static final Logger logger = Logger.getLogger(RCompJob.class);
    private CountDownLatch waitRLatch = new CountDownLatch(1);
    private ProcessPool processPool;
    private Process process;

    protected RCompJob() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws JobCancelledException {
        List<String> parameterValues;
        this.cancelCheck();
        this.updateStateDetailToClient("initialising R");
        ArrayList<BufferedReader> inputReaders = new ArrayList<BufferedReader>();
        inputReaders.add(new BufferedReader(new StringReader("setwd(\"" + this.jobDataDir.getAbsolutePath() + "\")\n")));
        inputReaders.add(new BufferedReader(new StringReader(this.toolDescription.getInitialiser())));
        int i = 0;
        try {
            parameterValues = this.inputMessage.getParameters(R_PARAMETER_SECURITY_POLICY, this.toolDescription);
        }
        catch (JobMessage.ParameterValidityException e) {
            this.outputMessage.setErrorMessage(e.getMessage());
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED_USER_ERROR, "");
            return;
        }
        for (ToolDescription.ParameterDescription param : this.toolDescription.getParameters()) {
            String value = new String(parameterValues.get(i));
            String rSnippet = RCompJob.transformVariable(param.getName(), value, param.isNumeric());
            logger.debug((Object)("added parameter (" + rSnippet + ")"));
            inputReaders.add(new BufferedReader(new StringReader(rSnippet)));
            ++i;
        }
        String script = (String)this.toolDescription.getImplementation();
        inputReaders.add(new BufferedReader(new StringReader(script)));
        inputReaders.add(new BufferedReader(new StringReader("print(\"" + SCRIPT_SUCCESSFUL_STRING + "\")\n")));
        this.cancelCheck();
        logger.debug((Object)"getting a process.");
        try {
            this.process = this.processPool.getProcess();
        }
        catch (Exception e) {
            this.outputMessage.setErrorMessage("Starting R failed.");
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.ERROR, "");
            return;
        }
        boolean processAlive = false;
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException itse) {
            processAlive = true;
        }
        if (!processAlive) {
            this.outputMessage.setErrorMessage("Starting R failed.");
            String output = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            try {
                String line = reader.readLine();
                while (line != null) {
                    output = output + line + "\n";
                    line = reader.readLine();
                }
                reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                line = reader.readLine();
                while (line != null) {
                    output = output + line + "\n";
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                logger.warn((Object)"could not read output stream");
            }
            this.outputMessage.setOutputText("R already finished.\n\n" + output);
            this.updateState(JobState.ERROR, "");
            return;
        }
        this.updateStateDetailToClient("running R");
        this.cancelCheck();
        logger.debug((Object)"about to start the R process monitor.");
        RProcessMonitor processMonitor = new RProcessMonitor();
        new Thread(processMonitor).start();
        StringBuilder inputStringBuilder = new StringBuilder();
        try {
            for (BufferedReader reader : inputReaders) {
                String line = reader.readLine();
                while (line != null) {
                    inputStringBuilder.append(line + "\n");
                    line = reader.readLine();
                }
            }
        }
        catch (IOException ioe) {
            logger.warn((Object)"creating R input failed");
        }
        this.outputMessage.setSourceCode(inputStringBuilder.toString());
        logger.debug((Object)"writing the input to R.");
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
            writer.write(inputStringBuilder.toString());
            writer.newLine();
            writer.flush();
            IOUtils.closeIfPossible(writer);
        }
        catch (IOException ioe) {
            logger.debug((Object)"writing input failed", (Throwable)ioe);
        }
        finally {
            IOUtils.closeIfPossible(writer);
        }
        this.cancelCheck();
        logger.debug((Object)"waiting for the script to finish.");
        try {
            this.waitRLatch.await();
        }
        catch (InterruptedException e) {
            this.outputMessage.setErrorMessage("Running R was interrupted.");
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.ERROR, "");
            return;
        }
        this.cancelCheck();
        logger.debug((Object)("done waiting for " + this.toolDescription.getID() + ", state is " + (Object)((Object)this.getState())));
        String output = processMonitor.getOutput();
        output = output.substring(output.indexOf("\n"));
        this.outputMessage.setOutputText(output);
        switch (this.getState()) {
            case RUNNING: {
                this.outputMessage.setErrorMessage("R did not finish before timeout.");
                this.updateState(JobState.TIMEOUT, "");
                return;
            }
            case COMPLETED: {
                this.updateState(JobState.RUNNING, "R script finished successfully");
                this.updateStateDetailToClient("R script finished successfully");
                return;
            }
            case FAILED: {
                if (this.outputMessage.getErrorMessage() == null || this.outputMessage.getErrorMessage().equals("")) {
                    this.outputMessage.setErrorMessage("Running R script failed.");
                }
                return;
            }
            case FAILED_USER_ERROR: {
                return;
            }
            case ERROR: {
                this.outputMessage.setErrorMessage("Reading R output failed.");
                return;
            }
        }
        throw new IllegalStateException("Illegal job state: " + (Object)((Object)this.getState()));
    }

    @Override
    protected void preExecute() throws JobCancelledException {
        super.preExecute();
    }

    @Override
    protected void postExecute() throws JobCancelledException {
        super.postExecute();
    }

    @Override
    protected void cleanUp() {
        try {
            if (this.process != null) {
                this.processPool.releaseProcess(this.process, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error when releasing process. ", (Throwable)e);
        }
        finally {
            super.cleanUp();
        }
    }

    public static String transformVariable(String name, String value, boolean isNumeric) {
        if (!isNumeric) {
            value = STRING_DELIMETER + value + STRING_DELIMETER;
        }
        if (isNumeric && value.trim().isEmpty()) {
            value = "NA";
        }
        name = name.replaceAll(" ", "_");
        return name + " <- " + value;
    }

    @Override
    protected void cancelRequested() {
        this.waitRLatch.countDown();
    }

    public void setProcessPool(ProcessPool processPool) {
        this.processPool = processPool;
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    private class RProcessMonitor
    implements Runnable {
        public final String ERROR_MESSAGE_TOKEN = "Error";
        private ArrayList<String> outputLines;

        private RProcessMonitor() {
        }

        @Override
        public void run() {
            logger.debug((Object)"R process monitor started.");
            this.outputLines = new ArrayList();
            BufferedReader reader = new BufferedReader(new InputStreamReader(RCompJob.this.process.getInputStream()));
            boolean readMore = true;
            try {
                String line = reader.readLine();
                while (readMore) {
                    if (line == null || line.contains(CompJob.SCRIPT_FAILED_STRING)) {
                        RCompJob.this.updateState(JobState.FAILED, "R script failed");
                        readMore = false;
                    } else if (line.contains(CompJob.SCRIPT_SUCCESSFUL_STRING)) {
                        RCompJob.this.updateState(JobState.COMPLETED, "R script finished successfully");
                        readMore = false;
                    } else {
                        this.outputLines.add(line);
                    }
                    line = reader.readLine();
                }
                if (RCompJob.this.getState() == JobState.FAILED) {
                    int errorLineNumber = -1;
                    for (int i = this.outputLines.size(); i > 0 && errorLineNumber == -1; --i) {
                        if (!this.outputLines.get(i - 1).startsWith("Error")) continue;
                        errorLineNumber = i - 1;
                    }
                    if (errorLineNumber != -1) {
                        String errorMessage = "";
                        errorMessage = errorMessage + this.outputLines.get(errorLineNumber).substring("Error".length()) + "\n";
                        for (int i = errorLineNumber + 1; i < this.outputLines.size() - 1; ++i) {
                            errorMessage = errorMessage + this.outputLines.get(i) + "\n";
                        }
                        errorMessage = errorMessage.substring(0, errorMessage.lastIndexOf("\n"));
                        if ((errorMessage = errorMessage.trim()).contains("CHIPSTER-NOTE:")) {
                            errorMessage = errorMessage.substring(errorMessage.indexOf("CHIPSTER-NOTE:") + "CHIPSTER-NOTE:".length());
                            errorMessage = errorMessage.trim();
                            RCompJob.this.updateState(JobState.FAILED_USER_ERROR, "");
                        }
                        RCompJob.this.outputMessage.setErrorMessage(errorMessage);
                    }
                }
            }
            catch (IOException e) {
                logger.debug((Object)"error in monitoring R process.");
                RCompJob.this.updateState(JobState.ERROR, "reading R output failed.");
            }
            RCompJob.this.waitRLatch.countDown();
        }

        public String getOutput() {
            StringBuilder output = new StringBuilder();
            for (String line : this.outputLines) {
                output.append(line + "\n");
            }
            return output.toString();
        }
    }

    public static class RParameterSecurityPolicy
    implements JobMessage.ParameterSecurityPolicy {
        private static final int MAX_VALUE_LENGTH = 1000;
        public static String NUMERIC_VALUE_PATTERN = "-?\\d*\\.?\\d*";
        public static String TEXT_VALUE_PATTERN = "[\\p{L}\\p{N}\\-+_:\\.,*() ]*";

        @Override
        public boolean isValueValid(String value, ToolDescription.ParameterDescription parameterDescription) {
            if (value.length() > 1000) {
                return false;
            }
            if (parameterDescription.isNumeric()) {
                return value.matches(NUMERIC_VALUE_PATTERN);
            }
            if (value.contains(RCompJob.STRING_DELIMETER)) {
                return false;
            }
            return value.matches(TEXT_VALUE_PATTERN);
        }
    }
}

