/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ProcessUtils {
    static final Logger logger = Logger.getLogger(ProcessUtils.class);

    public static void main(String[] args) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder("python", "-c", "blob = \" \" * (2**33); import time; time.sleep(20)");
        builder.redirectErrorStream(true);
        Process p = builder.start();
        try {
            long pid = ProcessUtils.getPid(p);
            HashSet<Long> allPids = new HashSet<Long>();
            allPids.add(pid);
            for (int i = 0; i < 10; ++i) {
                ProcessUtils.printProcess(pid);
                allPids.addAll(ProcessUtils.getChildren(pid, true));
                Iterator iterator = allPids.iterator();
                while (iterator.hasNext()) {
                    long childPid = (Long)iterator.next();
                    System.out.print("    ");
                    ProcessUtils.printProcess(childPid);
                }
                System.out.println(ProcessUtils.getTotalMemory(allPids) / 1024L + "MB");
                Thread.sleep(1000L);
            }
            IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)System.out);
            IOUtils.copy((InputStream)p.getErrorStream(), (OutputStream)System.err);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static long getTotalMemory(Collection<Long> pids) {
        return pids.stream().mapToLong(childPid -> ProcessUtils.getMemoryWithoutException(childPid)).sum();
    }

    public static void printProcess(long pid) throws IOException {
        System.out.println("pid " + pid + " comm " + StringUtils.abbreviate((String)ProcessUtils.getCommand(pid), (int)16) + " rss " + ProcessUtils.humanFriendly(ProcessUtils.getMemory(pid)) + " ppid " + ProcessUtils.getParent(pid));
    }

    public static String humanFriendly(Long l) {
        if (l == null) {
            return null;
        }
        return "" + l / 1024L + "MB";
    }

    private static Long getParent(long pid) throws IOException {
        return ProcessUtils.getPsLong("ppid", pid);
    }

    private static String getCommand(long pid) throws IOException {
        return ProcessUtils.getPsString("comm", pid);
    }

    private static Long getMemoryWithoutException(long pid) {
        try {
            Long mem = ProcessUtils.getMemory(pid);
            if (mem == null) {
                return 0L;
            }
            return mem;
        }
        catch (IOException e) {
            logger.warn((Object)"exception while getting memory usage", (Throwable)e);
            return 0L;
        }
    }

    private static Long getMemory(long pid) throws IOException {
        Long kilobytes = ProcessUtils.getPsLong("rss", pid);
        if (kilobytes == null) {
            return null;
        }
        return kilobytes * 1024L;
    }

    private static Long getPsLong(String psKey, long pid) throws IOException {
        String valueString = ProcessUtils.getPsString(psKey, pid);
        if (valueString == null) {
            return null;
        }
        return Long.parseLong(valueString);
    }

    private static String getPsString(String psKey, long pid) throws IOException {
        String output = ProcessUtils.execCmd("ps", "-o", psKey, "-p", "" + pid);
        String[] lines = output.split("\n");
        if (lines.length != 2) {
            return null;
        }
        return lines[1].trim();
    }

    private static List<Long> getChildren(long pid, boolean recursive) throws IOException {
        String pidLines = ProcessUtils.execCmd("pgrep", "-P", "" + pid);
        ArrayList<Long> pids = new ArrayList<Long>();
        for (String pidString : pidLines.split("\n")) {
            if (pidString.trim().isEmpty()) continue;
            Long childPid = Long.parseLong(pidString);
            pids.add(childPid);
            if (!recursive) continue;
            pids.addAll(ProcessUtils.getChildren(childPid, recursive));
        }
        return pids;
    }

    public static String execCmd(String ... cmd) throws IOException {
        Process proc = Runtime.getRuntime().exec(cmd);
        try (InputStream is = proc.getInputStream();){
            try (InputStream es = proc.getErrorStream();){
                String err = IOUtils.toString((InputStream)es, (String)"UTF-8");
                if (!err.isEmpty()) {
                    throw new RuntimeException("error in command: " + err + "(" + StringUtils.join((Object[])cmd, (String)" ") + ")");
                }
            }
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
    }

    public static Long getPid(Process process) {
        if (process == null) {
            return null;
        }
        Class<?> clazz = process.getClass();
        try {
            if (clazz.getName().equals("java.lang.UNIXProcess")) {
                Field pidField = clazz.getDeclaredField("pid");
                pidField.setAccessible(true);
                Object value = pidField.get(process);
                if (value instanceof Integer) {
                    return ((Integer)value).longValue();
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            logger.error((Object)"failed to get the pid of the process", (Throwable)e);
        }
        return null;
    }

    public static class ProcessResourceMonitor {
        private Long pid;
        private HashSet<Long> allPids = new HashSet();
        private Long maxMem;
        private Process javaProcess;

        public ProcessResourceMonitor(Process javaProcess) {
            this.javaProcess = javaProcess;
        }

        public Long getMaxMem() {
            return this.maxMem;
        }

        public void update() throws IOException {
            if (this.pid == null) {
                this.pid = ProcessUtils.getPid(this.javaProcess);
                this.allPids.add(this.pid);
            }
            if (this.pid != null) {
                this.allPids.addAll(ProcessUtils.getChildren(this.pid, true));
                Long mem = ProcessUtils.getTotalMemory(this.allPids);
                if (this.maxMem == null || mem > this.maxMem) {
                    this.maxMem = mem;
                }
                logger.debug((Object)("pid " + this.pid + " mem " + this.maxMem + " pid count " + this.allPids.size()));
            }
        }
    }
}

