/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ScatterplotValue;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.SelectionText;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.PassiveItem;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ScaleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ScatterplotPoint;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Selectable;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class ScatterplotTrack
extends ScaleTrack {
    private TreeMap<IndexKey, ScatterplotPoint> data = new TreeMap();
    private Color defaultColor;
    private int minSize = 2;
    private DataType column = null;
    private int floatListIndex;

    private ScatterplotTrack(Color color, int height, float minValue, float maxValue) {
        super(height, minValue, maxValue);
        this.defaultColor = color;
    }

    public ScatterplotTrack(Color color, int height, float minValue, float maxValue, DataType column) {
        this(color, height, minValue, maxValue);
        this.column = column;
    }

    public ScatterplotTrack(Color color, int height, float minValue, float maxValue, int floatArrayIndex, int minBpLength, long maxBpLength) {
        this(color, height, minValue, maxValue);
        this.floatListIndex = floatArrayIndex;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    @Override
    public List<Selectable> getSelectables() {
        LinkedList<Selectable> items = new LinkedList<Selectable>();
        if (this.data != null) {
            items.add(new PassiveItem(this.getScaleDrawables()));
            Iterator<IndexKey> iter = this.data.keySet().iterator();
            while (iter.hasNext()) {
                ScatterplotPoint point = this.data.get(iter.next());
                if (!this.getView().requestIntersects(point.getRegion())) {
                    iter.remove();
                    continue;
                }
                point.render(this.getView(), this.minSize, this);
                items.add(point);
            }
        }
        return items;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (Feature feature : dataResult.getFeatures()) {
            IndexKey key = feature.getIndexKey();
            if (this.data.containsKey(key)) continue;
            Float value = null;
            Color itemColor = this.defaultColor;
            SelectionText text = null;
            if (feature.getValueObject() instanceof SelectionText) {
                text = (SelectionText)feature.getValueObject();
            }
            if (this.column != null) {
                Object obj = feature.values.get((Object)this.column);
                if (obj instanceof SelectionText) {
                    SelectionText textObj;
                    text = textObj = (SelectionText)obj;
                }
                if (obj instanceof ScatterplotValue) {
                    ScatterplotValue valueObj = (ScatterplotValue)obj;
                    value = valueObj.getScatterplotValue();
                    if (valueObj.getScatterplotColor() != null) {
                        itemColor = valueObj.getScatterplotColor();
                    }
                } else if (obj != null) {
                    value = (Float)obj;
                }
            } else {
                List floatList = (List)feature.values.get((Object)DataType.FLOAT_LIST);
                value = (Float)floatList.get(this.floatListIndex);
            }
            ScatterplotPoint point = new ScatterplotPoint(feature.region, key, value, itemColor, text);
            if (value == null) continue;
            this.data.put(key, point);
        }
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.REGION);
        if (this.column == null) {
            this.addDataType(DataType.FLOAT_LIST);
        } else {
            this.addDataType(this.column);
        }
    }

    @Override
    public void updateLayout() {
    }
}

