/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.SelectionText;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.PeakSelectable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Selectable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class RegionTrack
extends Track {
    private TreeMap<IndexKey, PeakSelectable> peaks = new TreeMap();
    private Color color;

    public RegionTrack(Color color) {
        this.color = color;
    }

    @Override
    public List<Selectable> getSelectables() {
        LinkedList<Selectable> items = new LinkedList<Selectable>();
        if (this.peaks != null) {
            Iterator<IndexKey> iter = this.peaks.keySet().iterator();
            while (iter.hasNext()) {
                PeakSelectable selectable = this.peaks.get(iter.next());
                if (!this.getView().requestIntersects(selectable.getRegion())) {
                    iter.remove();
                    continue;
                }
                selectable.render(this.getView(), this.color);
                items.add(selectable);
            }
        }
        return items;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (Feature feature : dataResult.getFeatures()) {
            IndexKey key = feature.getIndexKey();
            if (this.peaks.containsKey(key)) continue;
            SelectionText text = null;
            Object value = feature.getValueObject();
            if (value instanceof SelectionText) {
                text = (SelectionText)value;
            }
            PeakSelectable selectable = new PeakSelectable(feature.region, key, text);
            this.peaks.put(key, selectable);
        }
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.CHROMOSOME);
        this.addDataType(DataType.START);
        this.addDataType(DataType.END);
    }

    @Override
    public int getTrackHeight() {
        return 17;
    }
}

