/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.visualisation.SelectionList;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.client.visualisation.methods.threed.ColorScalePanel;
import fi.csc.microarray.client.visualisation.methods.threed.DataModel;
import fi.csc.microarray.client.visualisation.methods.threed.Scatterplot3D;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.LinkUtils;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Scatterplot3DPCA
extends Scatterplot3D {
    DataBean phenoBean;
    private List<String> colorGroupNames;
    private JScrollPane legendScroller;
    private LinkedList<Float> colorGroupValues;

    @Override
    public void initialise(VisualisationFrame frame) throws Exception {
        super.initialise(frame);
    }

    @Override
    public SelectionList createListPanel() {
        return new SelectionList("Chips", false, false);
    }

    @Override
    protected void refreshAxisBoxes(DataBean data) {
        List<Object> phenoCols;
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        this.updateCombo(this.xBox, data);
        this.updateCombo(this.yBox, data);
        this.updateCombo(this.zBox, data);
        this.phenoBean = LinkUtils.retrieveInherited(data, DataBean.Link.ANNOTATION);
        if (this.phenoBean != null) {
            phenoCols = Arrays.asList(VisualisationUtilities.getVariablesFilteredInclusive(this.phenoBean, "", false));
        } else {
            phenoCols = new LinkedList<Visualisation.Variable>();
            phenoCols.add(new Visualisation.Variable("No phenodata", ""));
        }
        Visualisation.fillComboBox(this.colorBox, phenoCols.toArray(new Visualisation.Variable[0]));
    }

    @Override
    protected void retrieveData(List<Visualisation.Variable> variables) throws MicroarrayException {
        Iterable<String> colorDataStrings;
        Iterable<String> identifier = this.data.queryFeatures("/identifier").asStrings();
        Iterable<Float> xValues = this.data.queryFeatures(variables.get(0).getExpression()).asFloats();
        Iterable<Float> yValues = this.data.queryFeatures(variables.get(1).getExpression()).asFloats();
        Iterable<Float> zValues = this.data.queryFeatures(variables.get(2).getExpression()).asFloats();
        String colorQuery = variables.get(3).getExpression();
        if (this.phenoBean != null) {
            colorDataStrings = this.phenoBean.queryFeatures(colorQuery).asStrings();
        } else {
            LinkedList<String> list = new LinkedList<String>();
            Iterator<Object> iter = xValues.iterator();
            while (iter.hasNext()) {
                iter.next();
                list.add("");
            }
            colorDataStrings = list;
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (String str : colorDataStrings) {
            nameSet.add(str);
        }
        this.colorGroupNames = new LinkedList<String>(nameSet);
        Collections.sort(this.colorGroupNames);
        this.colorGroupValues = new LinkedList();
        for (String str : this.colorGroupNames) {
            this.colorGroupValues.add(Float.valueOf(this.colorGroupNames.indexOf(str)));
        }
        LinkedList<Float> colorDataValues = new LinkedList<Float>();
        for (String str : colorDataStrings) {
            colorDataValues.add(Float.valueOf(this.colorGroupNames.indexOf(str)));
        }
        this.getDataModel().setData(identifier, xValues, yValues, zValues, colorDataValues);
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return super.canVisualise(bean) && bean.hasTypeTag(MicroarrayModule.TypeTags.EXPRESSION_PRIMARY_COMPONENTS_CHIPWISE);
    }

    @Override
    protected void useButtonPressed() {
        ArrayList<Visualisation.Variable> vars = new ArrayList<Visualisation.Variable>();
        vars.add((Visualisation.Variable)this.xBox.getSelectedItem());
        vars.add((Visualisation.Variable)this.yBox.getSelectedItem());
        vars.add((Visualisation.Variable)this.zBox.getSelectedItem());
        vars.add((Visualisation.Variable)this.colorBox.getSelectedItem());
        this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, MicroarrayModule.VisualisationMethods.SCATTERPLOT3DPCA, vars, this.getFrame().getDatas(), this.getFrame().getType(), this.getFrame()));
    }

    @Override
    protected JComponent getColorLabel() {
        JTextArea label = new JTextArea("Color from\nphenodata:");
        label.setOpaque(false);
        label.setEditable(false);
        return label;
    }

    @Override
    protected JComponent getColorScalePanel() {
        if (this.scalePanel == null) {
            this.scalePanel = new ColorScalePanel(this.getDataModel(), this.colorGroupNames, this.colorGroupValues);
            this.legendScroller = new JScrollPane(this.scalePanel);
            this.legendScroller.setPreferredSize(new Dimension(50, 300));
        }
        return this.legendScroller;
    }

    @Override
    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new PCADataModel(DataModel.qualitatativeColorScheme);
        }
        return this.dataModel;
    }

    public class PCADataModel
    extends DataModel {
        public PCADataModel(Color[] colorScheme) {
            super(colorScheme);
        }

        @Override
        public Color getColorFor(float value) {
            Color c = Color.gray;
            int index = (int)value;
            if (index >= 0 && index < Scatterplot3DPCA.this.colorGroupNames.size() && index < this.getColorScheme().length) {
                return this.getColorScheme()[index];
            }
            return c;
        }
    }
}

