/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.serverfiles;

import fi.csc.microarray.client.serverfiles.ServerFile;
import fi.csc.microarray.filebroker.DbSession;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import javax.swing.filechooser.FileSystemView;

public class ServerFileSystemView
extends FileSystemView {
    private ServerFile rootFile;

    public ServerFileSystemView(ServerFile rootFile) {
        this.rootFile = rootFile;
    }

    public static ServerFileSystemView parseFromPaths(String prefix, List<DbSession> sessions) throws MalformedURLException {
        HashMap<String, ServerFile> dirs = new HashMap<String, ServerFile>();
        ServerFile root = new ServerFile(prefix + "/");
        dirs.put(prefix + "/", root);
        for (DbSession session : sessions) {
            String path = session.getName();
            String fullPath = prefix + "/" + path;
            ServerFile file = new ServerFile(fullPath);
            ServerFile parent = (ServerFile)dirs.get(fullPath.substring(0, fullPath.substring(0, fullPath.length() - 1).lastIndexOf("/") + 1));
            parent.addChild(file);
            if (!file.isDirectory()) continue;
            dirs.put(fullPath, file);
        }
        return new ServerFileSystemView(root);
    }

    @Override
    public File createNewFolder(File aContainingDir) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File[] getRoots() {
        return new File[]{this.rootFile};
    }

    public File getRoot() {
        return this.rootFile;
    }

    @Override
    public boolean isHiddenFile(File f) {
        return false;
    }

    @Override
    public boolean isRoot(File f) {
        return this.rootFile.equals(f);
    }

    @Override
    public File getHomeDirectory() {
        return this.rootFile;
    }

    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        return dir.listFiles();
    }

    @Override
    public String getSystemDisplayName(File f) {
        return f.getName();
    }

    @Override
    public File getParentDirectory(File dir) {
        return dir.getParentFile();
    }

    @Override
    public boolean isDrive(File dir) {
        return this.rootFile.equals(dir);
    }

    public File getExampleSessionDir() {
        for (File file : this.rootFile.listFiles()) {
            ServerFile serverFile;
            if (!(file instanceof ServerFile) || !(serverFile = (ServerFile)file).getName().equals("Example sessions")) continue;
            return serverFile;
        }
        ServerFile file = new ServerFile(this.rootFile, "Example sessions/");
        this.rootFile.addChild(file);
        return file;
    }

    @Override
    public File createFileObject(String path) {
        ServerFile f = new ServerFile(path);
        return f;
    }

    @Override
    public File createFileObject(File dir, String filename) {
        if (dir == null) {
            return new ServerFile(filename);
        }
        return new ServerFile(dir, filename);
    }
}

