/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import fi.csc.microarray.client.operation.parameter.PercentageParameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PercentageInputComponent
extends ParameterInputComponent
implements ChangeListener {
    private JSlider slider;
    private JLabel numberLabel;
    private PercentageParameter param;
    private int state;

    public PercentageInputComponent(PercentageParameter param, ParameterPanel parameterPanel) {
        super(parameterPanel);
        this.param = param;
        this.state = 0;
        int initValue = 0;
        if (param.getIntegerValue() != null) {
            initValue = param.getIntegerValue();
        }
        this.slider = new JSlider(0, 0, 100, initValue);
        this.slider.setMajorTickSpacing(50);
        this.slider.setMinorTickSpacing(10);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(false);
        this.slider.addChangeListener(this);
        this.slider.addFocusListener(this);
        this.slider.setPreferredSize(new Dimension(100, 40));
        this.numberLabel = new JLabel(param.getIntegerValue() + "%", 0);
        this.numberLabel.setPreferredSize(new Dimension(40, 30));
        this.numberLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.add((Component)this.slider, "West");
        this.add((Component)this.numberLabel, "East");
    }

    @Override
    public Parameter getParameter() {
        return this.param;
    }

    @Override
    public boolean inputIsValid() {
        return this.state == 0 || this.state == 1;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.slider) {
            Integer value = this.slider.getValue();
            this.numberLabel.setText(value + "%");
            if (this.param.checkValidityOf(value)) {
                this.param.setValue(value);
                this.setState(1);
            } else {
                this.setState(-1);
            }
        }
    }

    private void setState(int newState) {
        String message = null;
        this.state = newState;
        switch (this.state) {
            case 1: {
                this.numberLabel.setForeground(Color.black);
                message = this.param.getDescription();
                this.getParentPanel().setMessage(message, Color.black);
                break;
            }
            case -1: {
                this.numberLabel.setForeground(Color.red);
                message = "Value for " + this.param.getID() + " must be between " + this.param.getMinValue() + "% and " + this.param.getMaxValue() + "%.";
                this.getParentPanel().setMessage(message, Color.red);
            }
        }
    }

    @Override
    public JComponent getParameterComponent() {
        return this.slider;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.getParentPanel().setMessage(this.param.getDescription(), Color.black);
    }
}

