/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import java.util.LinkedList;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.annotations.IJsrParamId;
import org.eclipse.jetty.websocket.jsr356.server.AnnotatedServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.server.JsrPathParamId;
import org.eclipse.jetty.websocket.jsr356.server.ServerEndpointMetadata;

public class AnnotatedServerEndpointMetadata
extends AnnotatedEndpointMetadata<ServerEndpoint, ServerEndpointConfig>
implements ServerEndpointMetadata {
    private final ServerEndpoint endpoint;
    private final AnnotatedServerEndpointConfig config;

    protected AnnotatedServerEndpointMetadata(Class<?> websocket, ServerEndpointConfig baseConfig) throws DeploymentException {
        super(websocket);
        ServerEndpoint anno = websocket.getAnnotation(ServerEndpoint.class);
        if (anno == null) {
            throw new InvalidWebSocketException("Unsupported WebSocket object, missing @" + ServerEndpoint.class + " annotation");
        }
        this.endpoint = anno;
        this.config = new AnnotatedServerEndpointConfig(websocket, anno, baseConfig);
        this.getDecoders().addAll(anno.decoders());
        this.getEncoders().addAll(anno.encoders());
    }

    public void customizeParamsOnClose(LinkedList<IJsrParamId> params) {
        super.customizeParamsOnClose(params);
        params.addFirst(JsrPathParamId.INSTANCE);
    }

    public void customizeParamsOnError(LinkedList<IJsrParamId> params) {
        super.customizeParamsOnError(params);
        params.addFirst(JsrPathParamId.INSTANCE);
    }

    public void customizeParamsOnOpen(LinkedList<IJsrParamId> params) {
        super.customizeParamsOnOpen(params);
        params.addFirst(JsrPathParamId.INSTANCE);
    }

    public void customizeParamsOnMessage(LinkedList<IJsrParamId> params) {
        super.customizeParamsOnMessage(params);
        params.addFirst(JsrPathParamId.INSTANCE);
    }

    public ServerEndpoint getAnnotation() {
        return this.endpoint;
    }

    @Override
    public AnnotatedServerEndpointConfig getConfig() {
        return this.config;
    }

    @Override
    public String getPath() {
        return this.config.getPath();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnnotatedServerEndpointMetadata[endpoint=");
        builder.append(this.endpoint);
        builder.append(",config=");
        builder.append(this.config);
        builder.append("]");
        return builder.toString();
    }
}

