/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.toolbox.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.toolbox.Toolbox;
import fi.csc.chipster.toolbox.ToolboxModule;
import fi.csc.chipster.toolbox.ToolboxTool;
import java.io.IOException;
import java.util.LinkedHashSet;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Singleton
@Path(value="modules")
public class ModuleResource {
    private Toolbox toolbox;

    public ModuleResource(Toolbox toolbox) throws IOException {
        this.toolbox = toolbox;
    }

    @GET
    @Produces(value={"application/json"})
    public final Response getModules() throws IOException {
        Toolbox localToolbox = this.toolbox;
        JsonNodeFactory factory = new JsonNodeFactory(false);
        ArrayNode modules = factory.arrayNode();
        String[] priorityModules = new String[]{"ngs", "microarray", "misc"};
        LinkedHashSet<ToolboxModule> orderedModules = new LinkedHashSet<ToolboxModule>();
        for (String name : priorityModules) {
            ToolboxModule module = localToolbox.getModule(name);
            if (module == null) continue;
            orderedModules.add(module);
        }
        for (ToolboxModule module : localToolbox.getModules()) {
            if (orderedModules.contains(module)) continue;
            orderedModules.add(module);
        }
        for (ToolboxModule toolboxModule : orderedModules) {
            ObjectNode module = factory.objectNode();
            module.put("name", toolboxModule.getNamePretty());
            ArrayNode categories = factory.arrayNode();
            module.set("categories", (JsonNode)categories);
            for (ToolboxModule.ToolboxCategory toolboxCategory : toolboxModule.getCategories()) {
                ObjectNode category = factory.objectNode();
                category.put("name", toolboxCategory.getName());
                category.put("color", toolboxCategory.getColor());
                category.put("hidden", toolboxCategory.isHidden());
                ArrayNode tools = factory.arrayNode();
                category.set("tools", (JsonNode)tools);
                for (ToolboxTool toolboxTool : toolboxCategory.getTools()) {
                    JsonNode tool = (JsonNode)RestUtils.getObjectMapper().convertValue((Object)toolboxTool.getSadlDescription(), JsonNode.class);
                    tools.add(tool);
                }
                categories.add((JsonNode)category);
            }
            modules.add((JsonNode)module);
        }
        return Response.ok((Object)modules).build();
    }

    @GET
    @Path(value="zip")
    @Produces(value={"application/octet-stream"})
    public Response getZip() {
        return Response.ok((Object)this.toolbox.getZipStream()).header("Content-Disposition", (Object)"attachment; filename=\"tools.zip\"").build();
    }

    public void setToolbox(Toolbox newToolbox) {
        this.toolbox = newToolbox;
    }
}

