/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.resource;

import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.hibernate.Transaction;
import fi.csc.chipster.sessiondb.model.TableStats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;

@Path(value="admin")
public class SessionDbAdminResource {
    private static Logger logger = LogManager.getLogger();
    private HibernateUtil hibernate;

    public SessionDbAdminResource(HibernateUtil hibernate) {
        this.hibernate = hibernate;
    }

    @GET
    @Path(value="tables")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"session-db"})
    @Transaction
    public Response get(@PathParam(value="id") UUID authorizationId, @Context SecurityContext sc) throws IOException {
        return Response.ok(this.getTableStats(this.hibernate.session())).build();
    }

    public ArrayList<TableStats> getTableStats(Session hibernateSession) {
        ArrayList<TableStats> tables = new ArrayList<TableStats>();
        Map classMetadata = hibernateSession.getSessionFactory().getAllClassMetadata();
        for (String className : classMetadata.keySet()) {
            Number size = (Number)hibernateSession.createCriteria(className).setProjection(Projections.rowCount()).uniqueResult();
            TableStats table = new TableStats();
            table.setName(className.substring(className.lastIndexOf(".") + 1));
            table.setSize((Long)size);
            tables.add(table);
        }
        return tables;
    }
}

