/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.resource;

import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.hibernate.Transaction;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Parameter;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.chipster.sessiondb.resource.SessionResource;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobResource {
    private static Logger logger = LogManager.getLogger();
    private final UUID sessionId;
    private SessionResource sessionResource;

    public JobResource() {
        this.sessionId = null;
    }

    public JobResource(SessionResource sessionResource, UUID id) {
        this.sessionResource = sessionResource;
        this.sessionId = id;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Transaction
    public Response get(@PathParam(value="id") UUID jobId, @Context SecurityContext sc) {
        Session session = this.sessionResource.getSessionForReading(sc, this.sessionId);
        Job result = this.getJob(jobId, this.getHibernate().session());
        if (result == null || result.getSession().getSessionId() != session.getSessionId()) {
            throw new NotFoundException();
        }
        return Response.ok((Object)result).build();
    }

    public Job getJob(UUID jobId, org.hibernate.Session hibernateSession) {
        Job job = (Job)hibernateSession.get(Job.class, (Serializable)jobId);
        hibernateSession.evict((Object)job);
        job.setInputs(new ArrayList<Input>(new LinkedHashSet<Input>(job.getInputs())));
        return job;
    }

    @GET
    @Produces(value={"application/json"})
    @Transaction
    public Response getAll(@Context SecurityContext sc) {
        Collection<Job> result = this.sessionResource.getSessionForReading(sc, this.sessionId).getJobs().values();
        return Response.ok(this.toJaxbList(result)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Transaction
    public Response post(Job job, @Context UriInfo uriInfo, @Context SecurityContext sc) {
        if (job.getJobId() != null) {
            throw new BadRequestException("job already has an id, post not allowed");
        }
        UUID id = RestUtils.createUUID();
        job.setJobId(id);
        Session session = this.sessionResource.getSessionForWriting(sc, this.sessionId);
        job.setSession(session);
        for (Input input : job.getInputs()) {
            input.setDbId(0);
        }
        for (Parameter param : job.getParameters()) {
            param.setDbId(0);
        }
        this.create(job, this.getHibernate().session());
        URI uri = uriInfo.getAbsolutePathBuilder().path(id.toString()).build(new Object[0]);
        return Response.created((URI)uri).build();
    }

    public void create(Job job, org.hibernate.Session hibernateSession) {
        hibernateSession.save((Object)job);
        this.sessionResource.publish(this.sessionId.toString(), new SessionEvent(this.sessionId, SessionEvent.ResourceType.JOB, job.getJobId(), SessionEvent.EventType.CREATE), hibernateSession);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Transaction
    public Response put(Job requestJob, @PathParam(value="id") UUID jobId, @Context SecurityContext sc) {
        requestJob.setJobId(jobId);
        Session session = this.sessionResource.getSessionForWriting(sc, this.sessionId);
        Job dbJob = (Job)this.getHibernate().session().get(Job.class, (Serializable)jobId);
        if (dbJob == null || dbJob.getSession().getSessionId() != session.getSessionId()) {
            throw new NotFoundException("job doesn't exist");
        }
        requestJob.setSession(session);
        for (Input input : requestJob.getInputs()) {
            input.setDbId(0);
        }
        for (Parameter param : requestJob.getParameters()) {
            param.setDbId(0);
        }
        this.update(requestJob, this.getHibernate().session());
        return Response.noContent().build();
    }

    public void update(Job job, org.hibernate.Session hibernateSession) {
        hibernateSession.merge((Object)job);
        this.sessionResource.publish(this.sessionId.toString(), new SessionEvent(this.sessionId, SessionEvent.ResourceType.JOB, job.getJobId(), SessionEvent.EventType.UPDATE), hibernateSession);
    }

    @DELETE
    @Path(value="{id}")
    @Transaction
    public Response delete(@PathParam(value="id") UUID jobId, @Context SecurityContext sc) {
        Session session = this.sessionResource.getSessionForWriting(sc, this.sessionId);
        Job dbJob = (Job)this.getHibernate().session().get(Job.class, (Serializable)jobId);
        if (dbJob == null || dbJob.getSession().getSessionId() != session.getSessionId()) {
            throw new NotFoundException("job not found");
        }
        this.deleteJob(dbJob, this.getHibernate().session());
        return Response.noContent().build();
    }

    public void deleteJob(Job job, org.hibernate.Session hibernateSession) {
        hibernateSession.delete((Object)job);
        this.sessionResource.publish(this.sessionId.toString(), new SessionEvent(this.sessionId, SessionEvent.ResourceType.JOB, job.getJobId(), SessionEvent.EventType.DELETE), hibernateSession);
    }

    private GenericEntity<Collection<Job>> toJaxbList(Collection<Job> result) {
        return new GenericEntity<Collection<Job>>(result){};
    }

    private HibernateUtil getHibernate() {
        return this.sessionResource.getHibernate();
    }
}

