/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.scheduler;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.websocket.PubSubServer;
import fi.csc.chipster.scheduler.JobCommand;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.microarray.messaging.JobState;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.websocket.MessageHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Scheduler
implements SessionDbClient.SessionEventListener,
MessageHandler.Whole<String>,
PubSubServer.TopicCheck {
    private Logger logger = LogManager.getLogger();
    private AuthenticationClient authService;
    private Config config;
    private ServiceLocatorClient serviceLocator;
    private String serviceId;
    private SessionDbClient sessionDbClient;
    private PubSubServer pubSubServer;
    ConcurrentLinkedQueue<UUID> scheduledJobs = new ConcurrentLinkedQueue();

    public Scheduler(Config config) {
        this.config = config;
    }

    public void startServer() throws ServletException, DeploymentException, InterruptedException, RestException, IOException {
        String username = "scheduler";
        String password = this.config.getPassword(username);
        this.serviceLocator = new ServiceLocatorClient(this.config);
        this.authService = new AuthenticationClient(this.serviceLocator, username, password);
        this.sessionDbClient = new SessionDbClient(this.serviceLocator, this.authService.getCredentials());
        this.sessionDbClient.subscribe("jobs", this, "scheduler-job-listener");
        this.pubSubServer = new PubSubServer(this.config.getString("scheduler-bind"), "events", this.authService, this, this, "scheduler-events");
        this.pubSubServer.start();
    }

    @Override
    public boolean isAuthorized(AuthPrincipal principal, String topic) {
        return principal.getRoles().contains("server");
    }

    public static void main(String[] args) throws Exception {
        Scheduler server = new Scheduler(new Config());
        server.startServer();
    }

    public void close() {
        try {
            this.sessionDbClient.close();
        }
        catch (IOException e) {
            this.logger.warn("failed to stop the session-db client", (Throwable)e);
        }
        this.pubSubServer.stop();
    }

    @Override
    public void onEvent(SessionEvent e) {
        this.logger.debug("received a job event: " + (Object)((Object)e.getResourceType()) + " " + (Object)((Object)e.getType()));
        if (SessionEvent.ResourceType.JOB == e.getResourceType() && (SessionEvent.EventType.CREATE == e.getType() || SessionEvent.EventType.UPDATE == e.getType())) {
            this.logger.debug("get job");
            try {
                Job job = this.sessionDbClient.getJob(e.getSessionId(), e.getResourceId());
                this.logger.debug("handle event");
                this.handleSessionDbEvent(e.getSessionId(), job);
            }
            catch (RestException ex) {
                this.logger.error("failed to handle a session event", (Throwable)ex);
            }
        }
    }

    private void handleSessionDbEvent(UUID sessionId, Job job) {
        this.logger.debug("handling a job with state " + job.getState());
        if (JobState.NEW == job.getState()) {
            this.schedule(sessionId, job);
        } else if (JobState.CANCELLED == job.getState()) {
            this.cancel(sessionId, job);
        }
    }

    private void cancel(UUID sessionId, Job job) {
        this.logger.info("cancel job " + job.getJobId());
        JobCommand cmd = new JobCommand(sessionId, job.getJobId(), null, JobCommand.Command.CANCEL);
        this.pubSubServer.publish(cmd);
    }

    private void schedule(UUID sessionId, Job job) {
        this.logger.debug("schedule job " + job.getJobId());
        this.scheduledJobs.add(job.getJobId());
        JobCommand cmd = new JobCommand(sessionId, job.getJobId(), null, JobCommand.Command.SCHEDULE);
        this.pubSubServer.publish(cmd);
    }

    public void onMessage(String message) {
        JobCommand compMsg = RestUtils.parseJson(JobCommand.class, message);
        switch (compMsg.getCommand()) {
            case OFFER: {
                this.logger.debug("received an offer for job " + compMsg.getJobId() + " from comp " + compMsg.getCompId());
                boolean firstOffer = this.scheduledJobs.remove(compMsg.getJobId());
                if (!firstOffer) break;
                this.logger.debug("choose offer " + compMsg.getCompId());
                this.pubSubServer.publish(new JobCommand(compMsg.getSessionId(), compMsg.getJobId(), compMsg.getCompId(), JobCommand.Command.CHOOSE));
                break;
            }
            case BUSY: {
                this.logger.info("comp busy");
                break;
            }
            case AVAILABLE: {
                this.logger.debug("comp available");
                break;
            }
            default: {
                this.logger.warn("unknown command: " + (Object)((Object)compMsg.getCommand()));
            }
        }
    }
}

