/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.websocket;

import fi.csc.chipster.rest.websocket.RetryHandler;
import fi.csc.chipster.rest.websocket.WebSocketClient;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.ws.rs.core.UriBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebSocketClientEndpoint
extends Endpoint {
    private static final Logger logger = LogManager.getLogger();
    private String uri;
    private String name;
    private MessageHandler messageHandler;
    private CountDownLatch disconnectLatch;
    private CountDownLatch connectLatch = new CountDownLatch(1);
    private CloseReason closeReason;
    private Throwable throwable;
    private Session session;
    private RetryHandler retryHandler;

    public WebSocketClientEndpoint(String uri, String name, MessageHandler.Whole<String> messageHandler, RetryHandler retryHandler) {
        this.uri = uri;
        this.name = name;
        this.messageHandler = messageHandler;
        this.retryHandler = retryHandler;
    }

    public void onOpen(Session session, EndpointConfig config) {
        String uriWithoutParams = UriBuilder.fromUri((String)this.uri).replaceQuery(null).toString();
        this.session = session;
        logger.info("websocket client " + this.name + " connected succesfully: " + uriWithoutParams);
        if (this.messageHandler != null) {
            session.addMessageHandler(this.messageHandler);
        }
        this.disconnectLatch = new CountDownLatch(1);
        this.connectLatch.countDown();
        if (this.retryHandler != null) {
            this.retryHandler.reset();
        }
    }

    public void onClose(Session session, CloseReason reason) {
        logger.info("websocket client " + this.name + " closed: " + reason.getReasonPhrase());
        this.closeReason = reason;
        this.connectLatch.countDown();
        this.disconnectLatch.countDown();
    }

    public void onError(Session session, Throwable thr) {
        logger.warn("websocket client " + this.name + " error: " + thr.getMessage(), thr);
        this.throwable = thr;
        this.connectLatch.countDown();
        this.disconnectLatch.countDown();
    }

    public void close() throws IOException {
        this.session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "client closing"));
        try {
            if (!this.disconnectLatch.await(1L, TimeUnit.SECONDS)) {
                logger.warn("failed to close the websocket client " + this.name);
            }
        }
        catch (InterruptedException e) {
            logger.warn("failed to close the websocket client " + this.name, (Throwable)e);
        }
    }

    public void waitForConnection() throws InterruptedException, WebSocketClient.WebSocketClosedException, WebSocketClient.WebSocketErrorException {
        this.connectLatch.await();
        if (this.closeReason != null) {
            throw new WebSocketClient.WebSocketClosedException(this.closeReason);
        }
        if (this.throwable != null) {
            throw new WebSocketClient.WebSocketErrorException(this.throwable);
        }
    }

    public void sendText(String text) throws IOException {
        this.session.getBasicRemote().sendText(text);
    }

    public void ping() throws IllegalArgumentException, IOException, TimeoutException, InterruptedException {
        logger.debug("ping");
        PongHandler pongHandler = new PongHandler();
        this.session.addMessageHandler((MessageHandler)pongHandler);
        this.session.getBasicRemote().sendPing(null);
        pongHandler.await();
        this.session.removeMessageHandler((MessageHandler)pongHandler);
    }

    public static class PongHandler
    implements MessageHandler.Whole<PongMessage> {
        private CountDownLatch latch = new CountDownLatch(1);

        public void onMessage(PongMessage message) {
            logger.debug("pong");
            this.latch.countDown();
        }

        public void await() throws TimeoutException, InterruptedException {
            boolean received = this.latch.await(2L, TimeUnit.SECONDS);
            if (!received) {
                throw new TimeoutException("timeout while waiting for pong message");
            }
        }
    }
}

