/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.exception;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.IOException;
import java.time.LocalDateTime;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LocalDateTimeContextResolver
implements ContextResolver<ObjectMapper> {
    final ObjectMapper mapper = new ObjectMapper();

    public LocalDateTimeContextResolver() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer());
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        this.mapper.registerModule((Module)module);
        this.mapper.registerModule((Module)new JaxbAnnotationModule());
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.mapper;
    }

    public static class LocalDateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime dateTime, JsonGenerator jg, SerializerProvider sp) throws IOException {
            jg.writeString(dateTime.toString());
        }
    }

    public static class LocalDateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException {
            ObjectCodec codec = jp.getCodec();
            TextNode node = (TextNode)codec.readTree(jp);
            String dateString = node.textValue();
            return LocalDateTime.parse(dateString);
        }
    }
}

