/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import fi.csc.chipster.rest.CORSResponseFilter;
import fi.csc.chipster.rest.exception.LocalDateTimeContextResolver;
import fi.csc.chipster.rest.exception.NotFoundExceptionMapper;
import fi.csc.chipster.rest.pretty.JsonPrettyPrintQueryParamContainerResponseFilter;
import fi.csc.chipster.servicelocator.resource.Service;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Parameter;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.messaging.JobState;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;

public class RestUtils {
    private static Logger logger = LogManager.getLogger();
    private static Random rand = new Random();

    public static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new LocalDateTimeContextResolver().getContext(null);
        return mapper;
    }

    public static String asJson(Object obj) {
        return RestUtils.asJson(obj, false);
    }

    public static String asJson(Object obj, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            ObjectMapper mapper = RestUtils.getObjectMapper();
            if (pretty) {
                mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)writer, obj);
            } else {
                mapper.writeValue((Writer)writer, obj);
            }
            return writer.toString();
        }
        catch (IOException e) {
            logger.error("json conversion failed", (Throwable)e);
            throw new InternalServerErrorException();
        }
    }

    public static <T> T parseJson(Class<T> obj, String json) {
        return RestUtils.parseJson(obj, json, true);
    }

    public static <T> T parseJson(Class<T> obj, String json, boolean failOnUnknownProperties) {
        try {
            StringReader reader = new StringReader(json);
            ObjectMapper mapper = RestUtils.getObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
            return (T)mapper.readValue((Reader)reader, obj);
        }
        catch (IOException e) {
            logger.error("json parsing failed", (Throwable)e);
            throw new InternalServerErrorException();
        }
    }

    public static List parseJson(Class<? extends Collection> collectionType, Class<?> itemType, String json) {
        return RestUtils.parseJson(collectionType, itemType, json, true);
    }

    public static List parseJson(Class<? extends Collection> collectionType, Class<?> itemType, String json, boolean failOnUnknownProperties) {
        try {
            StringReader reader = new StringReader(json);
            ObjectMapper mapper = RestUtils.getObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
            return (List)mapper.readValue((Reader)reader, (JavaType)mapper.getTypeFactory().constructCollectionType(collectionType, itemType));
        }
        catch (IOException e) {
            logger.error("json parsing failed", (Throwable)e);
            throw new InternalServerErrorException();
        }
    }

    public static Date toDate(LocalDateTime dateTime) {
        if (dateTime != null) {
            return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date != null) {
            return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        return null;
    }

    public static String createId() {
        return RestUtils.createUUID().toString();
    }

    public static UUID createUUID() {
        return UUID.randomUUID();
    }

    public static Session getRandomSession() {
        Session s = new Session();
        s.setName("session" + rand.nextInt(1000));
        s.setCreated(LocalDateTime.now());
        s.setAccessed(LocalDateTime.now());
        return s;
    }

    public static Dataset getRandomDataset() {
        Dataset d = new Dataset();
        d.setName("dataset" + d.getDatasetId());
        d.setSourceJob(RestUtils.createUUID());
        d.setX(100);
        d.setY(100);
        return d;
    }

    public static Job getRandomJob() {
        Job j = new Job();
        j.setEndTime(LocalDateTime.now());
        j.setState(JobState.NEW);
        j.setStartTime(LocalDateTime.now());
        j.setToolCategory("utilities");
        j.setToolDescription("very important tool");
        j.setToolId("UtilTool.py");
        j.setToolName("Utility tool");
        ArrayList<Parameter> p = new ArrayList<Parameter>();
        p.add(RestUtils.getRandomParameter());
        p.add(RestUtils.getRandomParameter());
        j.setParameters(p);
        ArrayList<Input> i = new ArrayList<Input>();
        i.add(RestUtils.getRandomInput());
        i.add(RestUtils.getRandomInput());
        j.setInputs(i);
        return j;
    }

    private static Input getRandomInput() {
        Input i = new Input();
        i.setInputId("inFile");
        i.setDisplayName("Input file");
        i.setDescription("Input file to process");
        i.setType("GENERIC");
        i.setDatasetId("apsodifupoiwuerpoiu");
        return i;
    }

    private static Parameter getRandomParameter() {
        Parameter p = new Parameter();
        p.setParameterId(RestUtils.createId());
        p.setDisplayName("Tool parameter");
        p.setDescription("Desckription of the tool parameter");
        p.setType(SADLSyntax.ParameterType.STRING);
        p.setValue("Parameter value");
        return p;
    }

    public static String basename(String path) {
        return new File(path).getName();
    }

    public static Service getRandomService() {
        Service s = new Service();
        s.setRole("session-db");
        s.setServiceId(RestUtils.createId());
        s.setUri("http://localhost:8080/sessionstorage");
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForShutdown(String name, HttpServer server) {
        System.out.println(name + " started");
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            logger.error(name + " failed", (Throwable)e);
        }
        finally {
            GrizzlyFuture future = server.shutdown();
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.warn(name + " shutdown failed", (Throwable)e);
            }
        }
    }

    public static ResourceConfig getDefaultResourceConfig() {
        return new ResourceConfig().property("jersey.config.disableAutoDiscovery", (Object)true).register(JacksonJaxbJsonProvider.class).packages(new String[]{NotFoundExceptionMapper.class.getPackage().getName()}).register(CORSResponseFilter.class).register(RolesAllowedDynamicFeature.class).register(JsonPrettyPrintQueryParamContainerResponseFilter.class);
    }

    public static void shutdown(String name, HttpServer httpServer) {
        GrizzlyFuture future = httpServer.shutdown();
        try {
            try {
                future.get(3L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                logger.warn(name + " server didn't stop gracefully");
                httpServer.shutdownNow();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("failed to shutdown the server " + name, (Throwable)e);
        }
    }

    public static boolean isSuccessful(int status) {
        return status >= 200 && status < 300;
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    public static void configureForDownload(Response.ResponseBuilder response, String name) {
        response.header("Content-Disposition", (Object)("attachment; filename=\"" + name + "\""));
    }

    public static void configureForDownload(HttpServletResponse response, String name) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
    }
}

