/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest;

import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Config {
    private static final String KEY_CONF_PATH = "conf-path";
    public static final String KEY_TOOLBOX_URL = "toolbox-url";
    public static final String KEY_TOOLBOX_PUBLIC_URL = "toolbox-url-pub";
    public static final String KEY_TOOLBOX_BIND_URL = "toolbox-bind-url";
    public static final String KEY_COMP_MAX_JOBS = "comp-max-jobs";
    public static final String KEY_COMP_SCHEDULE_TIMEOUT = "comp-schedule-timeout";
    public static final String KEY_COMP_OFFER_DELAY = "comp-offer-delay";
    public static final String KEY_COMP_SWEEP_WORK_DIR = "comp-sweep-work-dir";
    public static final String KEY_COMP_TIMEOUT_CHECK_INTERVAL = "comp-timeout-check-interval";
    public static final String KEY_COMP_JOB_HEARTBEAT_INTERVAL = "comp-job-heartbeat-interval";
    public static final String KEY_COMP_AVAILABLE_INTERVAL = "comp-available-interval";
    public static final String KEY_TOOLS_BIN_PATH = "tools-bin-path";
    public static final String USERNAME_SESSION_DB = "session-db";
    public static final String USERNAME_SERVICE_LOCATOR = "service-locator";
    public static final String USERNAME_SCHEDULER = "scheduler";
    public static final String USERNAME_COMP = "comp";
    public static final String USERNAME_FILE_BROKER = "file-broker";
    public static final String USERNAME_SESSION_WORKER = "session-worker";
    public static final String USERNAME_PROXY = "proxy";
    public static final List<String> services = Arrays.asList("session-db", "service-locator", "scheduler", "comp", "file-broker", "session-worker", "proxy");
    private static Map<String, String> serviceAccounts = new HashMap<String, String>();
    private Logger logger;
    private LoggerContext log4jContext;
    private HashMap<String, String> defaults;
    private HashMap<String, String> variables;
    private HashMap<String, String> variableDefaults;
    private static boolean conFFileWarnShown;

    public Config() {
        for (String string : services) {
            serviceAccounts.put(string, string + "-password");
        }
        this.defaults = new HashMap();
        this.defaults.put("web", "http://{{public-ip}}:8000");
        this.defaults.put("authentication-service", "http://{{public-ip}}:8002");
        this.defaults.put("authentication-service-pub", "http://{{public-ip}}:8002");
        this.defaults.put(USERNAME_SERVICE_LOCATOR, "http://{{public-ip}}:8003");
        this.defaults.put(USERNAME_SESSION_DB, "http://{{public-ip}}:8004");
        this.defaults.put("session-db-events", "ws://{{public-ip}}:8005");
        this.defaults.put("session-db-pub", "http://{{public-ip}}:8004");
        this.defaults.put("session-db-events-pub", "ws://{{public-ip}}:8005");
        this.defaults.put(USERNAME_SCHEDULER, "ws://{{public-ip}}:8006");
        this.defaults.put(USERNAME_FILE_BROKER, "http://{{public-ip}}:8007");
        this.defaults.put("file-broker-pub", "http://{{public-ip}}:8007");
        this.defaults.put(KEY_TOOLBOX_URL, "http://{{public-ip}}:8008");
        this.defaults.put(KEY_TOOLBOX_PUBLIC_URL, "http://{{public-ip}}:8008");
        this.defaults.put(USERNAME_SESSION_WORKER, "http://{{public-ip}}:8009");
        this.defaults.put("session-worker-pub", "http://{{public-ip}}:8009");
        this.defaults.put("web-bind", "http://{{bind-ip}}:8000");
        this.defaults.put("proxy-bind", "http://{{bind-ip}}:8001");
        this.defaults.put("proxy-admin-bind", "http://{{admin-bind-ip}}:9001");
        this.defaults.put("authentication-service-bind", "http://{{bind-ip}}:8002");
        this.defaults.put("service-locator-bind", "http://{{bind-ip}}:8003");
        this.defaults.put("session-db-bind", "http://{{bind-ip}}:8004");
        this.defaults.put("session-db-events-bind", "ws://{{bind-ip}}:8005");
        this.defaults.put("scheduler-bind", "ws://{{bind-ip}}:8006");
        this.defaults.put("file-broker-bind", "http://{{bind-ip}}:8007");
        this.defaults.put(KEY_TOOLBOX_BIND_URL, "http://{{bind-ip}}:8008");
        this.defaults.put("session-worker-bind", "http://{{bind-ip}}:8009");
        this.defaults.put(KEY_COMP_MAX_JOBS, "2147483647");
        this.defaults.put(KEY_COMP_SCHEDULE_TIMEOUT, "10");
        this.defaults.put(KEY_COMP_OFFER_DELAY, "100");
        this.defaults.put(KEY_COMP_SWEEP_WORK_DIR, "true");
        this.defaults.put(KEY_COMP_TIMEOUT_CHECK_INTERVAL, "1000");
        this.defaults.put(KEY_COMP_JOB_HEARTBEAT_INTERVAL, "15000");
        this.defaults.put(KEY_COMP_AVAILABLE_INTERVAL, "60000");
        this.defaults.put("session-db-replicate", "false");
        this.defaults.put("session-db-name", USERNAME_SESSION_DB);
        this.defaults.put("session-db-hibernate-schema", "update");
        this.defaults.put("web-root-path", "../chipster-web/");
        this.defaults.put(KEY_CONF_PATH, "conf/chipster.yaml");
        this.defaults.put(KEY_TOOLS_BIN_PATH, "/opt/chipster/tools");
        for (Map.Entry entry : serviceAccounts.entrySet()) {
            String username = (String)entry.getKey();
            String passwordConfigKey = (String)entry.getValue();
            this.defaults.put(passwordConfigKey, username);
        }
        this.variables = new HashMap();
        this.variableDefaults = new HashMap();
        this.variableDefaults.put("public-ip", "127.0.0.1");
        this.variableDefaults.put("bind-ip", "0.0.0.0");
        this.variableDefaults.put("admin-bind-ip", "127.0.0.1");
        this.configureLog4j();
    }

    public void configureLog4j() {
        String cn = "org.apache.logging.log4j.jul.LogManager";
        System.setProperty("java.util.logging.manager", cn);
        this.logger = LogManager.getLogger();
        java.util.logging.LogManager lm = java.util.logging.LogManager.getLogManager();
        if (!cn.equals(lm.getClass().getName())) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(cn);
            }
            catch (ClassNotFoundException cnfe) {
                this.logger.warn("log4j-jul jar not found from the class path. Logging to  can't be configured with log4j", (Throwable)cnfe);
            }
            this.logger.warn("JUL to log4j bridge couldn't be initialized, because Logger or LoggerManager was already created. Make sure the logger field of the startup class isn't static and call this mehtod before instantiating it.");
        }
    }

    public static void setLoggingLevel(String logger, Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger);
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
    }

    public static Level getLoggingLevel(String logger) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger);
        return loggerConfig.getLevel();
    }

    public String getString(String key) throws IOException {
        return this.getString(key, true, true, true);
    }

    public String getString(String key, boolean env, boolean file, boolean defaultValue) throws IOException {
        String value = null;
        if (env) {
            value = System.getenv(key.replace("-", "_"));
        }
        if (value == null && file) {
            value = this.getFromFile(key);
        }
        if (value == null && defaultValue) {
            value = this.getDefault(key);
        }
        return value;
    }

    private String getFromFile(String key) throws IOException {
        block6: {
            String confFilePath = this.getString(KEY_CONF_PATH, true, false, true);
            try {
                YamlReader reader = new YamlReader((Reader)new FileReader(confFilePath));
                Object object = reader.read();
                if (object instanceof Map) {
                    Map confFileMap = (Map)object;
                    Object valueObj = confFileMap.get(key);
                    if (valueObj instanceof String) {
                        return (String)valueObj;
                    }
                } else if (object != null) {
                    throw new RuntimeException("configuration file should be a yaml map, but it is " + object);
                }
            }
            catch (FileNotFoundException e) {
                if (conFFileWarnShown) break block6;
                this.logger.warn("configuration file " + confFilePath + " not found, using environment variables or defaults");
                conFFileWarnShown = true;
            }
        }
        return null;
    }

    public String getPassword(String username) throws IOException {
        String key = serviceAccounts.get(username);
        if (this.isDefault(key)) {
            this.logger.warn("default password for username " + username);
        }
        return this.getString(key);
    }

    private String getDefault(String key) {
        String template = this.defaults.get(key);
        if (template == null) {
            throw new IllegalArgumentException("configuration key not found: " + key);
        }
        return this.replaceVariables(template);
    }

    public boolean isDefault(String key) throws IOException {
        return this.getDefault(key).equals(this.getString(key));
    }

    public void setVariable(String key, String value) {
        this.variables.put(key, value);
    }

    private String replaceVariables(String template) {
        for (String variableName : this.variableDefaults.keySet()) {
            String variableValue = this.variables.get(variableName);
            if (variableValue == null) {
                variableValue = System.getenv(variableName);
            }
            if (variableValue == null) {
                variableValue = this.variableDefaults.get(variableName);
            }
            template = template.replaceAll(Pattern.quote("{{" + variableName + "}}"), variableValue);
        }
        return template;
    }

    public URI getURI(String key) throws IOException {
        return URI.create(this.getString(key));
    }

    public int getInt(String key) throws NumberFormatException, IOException {
        return Integer.parseInt(this.getString(key));
    }

    public boolean getBoolean(String key) throws IOException {
        return "true".equalsIgnoreCase(this.getString(key));
    }

    public void set(String key, String value) {
        this.defaults.put(key, value);
    }
}

