/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.proxy;

import fi.csc.chipster.proxy.ConnectionManager;
import fi.csc.chipster.proxy.HttpProxyServlet;
import fi.csc.chipster.proxy.WebSocketProxyServlet;
import fi.csc.chipster.proxy.model.Connection;
import fi.csc.chipster.proxy.model.Route;
import fi.csc.chipster.proxy.model.RouteStats;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;

public class ProxyServer {
    private static final Logger logger = LogManager.getLogger();
    public static final String PREFIX = "prefix";
    public static final String PROXY_TO = "proxyTo";
    private Server jetty;
    private ServletContextHandler context;
    private ConcurrentHashMap<ServletHolder, String> servletsToRemove = new ConcurrentHashMap();
    private ConnectionManager connectionManager = new ConnectionManager();

    public static void main(String[] args) throws Exception {
        ProxyServer proxy = new ProxyServer(new URI("http://127.0.0.1:8000"));
        proxy.addRoute("test", "http://chipster.csc.fi");
        proxy.startServer();
        logger.info("proxy up and running");
    }

    public ProxyServer(URI baseUri) {
        this.connectionManager.setListener(new ConnectionManager.ConnectionListener(){

            @Override
            public void connectionRemoved(Connection connection) {
                ProxyServer.this.removeUnusedServlets();
            }
        });
        this.jetty = new Server();
        ServerConnector connector = new ServerConnector(this.jetty);
        connector.setPort(baseUri.getPort());
        connector.setHost(baseUri.getHost());
        this.jetty.addConnector((Connector)connector);
        HandlerCollection handlers = new HandlerCollection();
        boolean enableJMX = true;
        if (enableJMX) {
            MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            this.jetty.addBean((Object)mbContainer);
            StatisticsHandler statisticsHandler = new StatisticsHandler();
            statisticsHandler.setHandler((Handler)handlers);
            this.jetty.setHandler((Handler)statisticsHandler);
        } else {
            this.jetty.setHandler((Handler)handlers);
        }
        this.context = new ServletContextHandler((HandlerContainer)handlers, "/", 1);
    }

    public void startServer() {
        try {
            this.jetty.start();
        }
        catch (Exception e) {
            logger.error("failed to start proxy", (Throwable)e);
        }
    }

    public void close() {
        try {
            this.jetty.stop();
        }
        catch (Exception e) {
            logger.warn("failed to stop the proxy", (Throwable)e);
        }
    }

    public void addRoute(String proxyPath, String targetUri) throws URISyntaxException {
        ServletHolder routeServlet;
        logger.info("add route " + proxyPath + " -> " + targetUri);
        String scheme = new URI(targetUri).getScheme().toLowerCase();
        if ("ws".equals(scheme) || "wss".equals(scheme)) {
            WebSocketProxyServlet servlet = new WebSocketProxyServlet(this.connectionManager);
            routeServlet = new ServletHolder((Servlet)servlet);
        } else {
            HttpProxyServlet servlet = new HttpProxyServlet(this.connectionManager);
            routeServlet = new ServletHolder((Servlet)servlet);
        }
        routeServlet.setInitParameter(PROXY_TO, targetUri);
        routeServlet.setInitParameter(PREFIX, "/" + proxyPath);
        this.context.getServletHandler().addServlet(routeServlet);
        this.updateMapping(proxyPath, routeServlet);
    }

    public List<Route> getRoutes() {
        ArrayList<Route> routes = new ArrayList<Route>();
        List<ServletMapping> mappings = Arrays.asList(this.context.getServletHandler().getServletMappings());
        for (ServletMapping mapping : mappings) {
            String pathSpec = mapping.getPathSpecs()[0];
            if (!this.isProxyPathSpec(pathSpec)) continue;
            Route route = new Route();
            route.setProxyPath(this.getProxyPath(pathSpec));
            route.setProxyTo(this.getServlet(this.getProxyPath(pathSpec), mappings).getInitParameter(PROXY_TO));
            routes.add(route);
        }
        return routes;
    }

    public List<RouteStats> getRouteStats() {
        ArrayList<RouteStats> stats = new ArrayList<RouteStats>();
        for (Route route : this.getRoutes()) {
            stats.add(this.connectionManager.getRouteStats(route));
        }
        return stats;
    }

    public void removeRoute(String proxyPath) {
        logger.info("remove route " + proxyPath);
        this.updateMapping(proxyPath, null);
    }

    public List<Connection> getConnections() {
        return this.connectionManager.getConnections();
    }

    private String getPathSpec(String proxyPath) {
        if (proxyPath.isEmpty()) {
            return "/*";
        }
        return "/" + proxyPath + "/*";
    }

    private String getProxyPath(String pathSpec) {
        if (this.isProxyPathSpec(pathSpec)) {
            return pathSpec.substring("/".length(), pathSpec.length() - "/*".length());
        }
        throw new IllegalArgumentException("illegal pathSpec");
    }

    private boolean isProxyPathSpec(String pathSpec) {
        return pathSpec.startsWith("/") && pathSpec.endsWith("/*");
    }

    private ServletMapping getServletMapping(String proxyPath, List<ServletMapping> mappings) {
        for (ServletMapping mapping : mappings) {
            String pathSpec = mapping.getPathSpecs()[0];
            if (!pathSpec.equals(this.getPathSpec(proxyPath))) continue;
            return mapping;
        }
        return null;
    }

    private ServletHolder getServlet(String proxyPath, List<ServletMapping> mappings) {
        ServletMapping mapping = this.getServletMapping(proxyPath, mappings);
        for (ServletHolder holder : this.context.getServletHandler().getServlets()) {
            if (!holder.getName().equals(mapping.getServletName())) continue;
            return holder;
        }
        return null;
    }

    public void updateMapping(String proxyPath, ServletHolder newHolder) {
        ArrayList<ServletMapping> mappings;
        ServletMapping oldMapping;
        ServletMapping[] mappingsArray = this.context.getServletHandler().getServletMappings();
        if (mappingsArray == null) {
            mappingsArray = new ServletMapping[]{};
        }
        if ((oldMapping = this.getServletMapping(proxyPath, mappings = new ArrayList<ServletMapping>(Arrays.asList(mappingsArray)))) != null) {
            ServletHolder oldServlet = this.getServlet(proxyPath, mappings);
            logger.info("old route " + proxyPath + " -> " + oldServlet.getInitParameter(PROXY_TO) + " will be removed later");
            this.servletsToRemove.put(oldServlet, proxyPath);
            mappings.remove(oldMapping);
        }
        if (newHolder != null) {
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(newHolder.getName());
            mapping.setPathSpec(this.getPathSpec(proxyPath));
            mappings.add(mapping);
        }
        this.context.getServletHandler().setServletMappings(mappings.toArray(new ServletMapping[0]));
        this.removeUnusedServlets();
    }

    public void removeServlet(ServletHolder holder) {
        ArrayList<ServletHolder> holders = new ArrayList<ServletHolder>(Arrays.asList(this.context.getServletHandler().getServlets()));
        holders.remove(holder);
        this.context.getServletHandler().setServlets(holders.toArray(new ServletHolder[0]));
    }

    private void removeUnusedServlets() {
        Iterator holdersIter = ((ConcurrentHashMap.KeySetView)this.servletsToRemove.keySet()).iterator();
        while (holdersIter.hasNext()) {
            String holderTargetURI;
            ServletHolder holder = (ServletHolder)holdersIter.next();
            String holderProxyPath = this.servletsToRemove.get(holder);
            if (this.connectionManager.hasOpenConnections(new Route(holderProxyPath, holderTargetURI = holder.getInitParameter(PROXY_TO)))) continue;
            logger.info("remove unused route " + holderProxyPath + " -> " + holderTargetURI);
            this.removeServlet(holder);
            holdersIter.remove();
        }
    }
}

