/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.comp;

import fi.csc.chipster.comp.RestPhenodataUtils;
import fi.csc.chipster.scheduler.JobCommand;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.MetadataEntry;
import fi.csc.chipster.sessiondb.model.Parameter;
import fi.csc.microarray.comp.ToolDescription;
import fi.csc.microarray.messaging.message.GenericJobMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.JobMessageUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class RestJobMessage
implements GenericJobMessage {
    private JobCommand jobCommand;
    private Job job;
    private HashMap<String, List<MetadataEntry>> metadata;

    public RestJobMessage(JobCommand jobCommand, Job job) {
        this.jobCommand = jobCommand;
        this.job = job;
    }

    public String getToolId() {
        return this.job.getToolId();
    }

    public String getJobId() {
        return this.job.getJobId().toString();
    }

    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (Input input : this.job.getInputs()) {
            if ("phenodata.tsv".equals(input.getInputId()) || "phenodata2.tsv".equals(input.getInputId())) continue;
            keys.add(input.getInputId());
        }
        return keys;
    }

    public String getId(String inputName) {
        for (Input input : this.job.getInputs()) {
            if (!input.getInputId().equals(inputName)) continue;
            return input.getDatasetId().toString();
        }
        return null;
    }

    public String getName(String inputName) {
        for (Input input : this.job.getInputs()) {
            if (!input.getInputId().equals(inputName)) continue;
            return input.getDisplayName();
        }
        return null;
    }

    public List<String> getParameters(JobMessage.ParameterSecurityPolicy securityPolicy, ToolDescription description) throws JobMessage.ParameterValidityException {
        HashMap<String, String> parameterIdToValueMap = new HashMap<String, String>();
        ArrayList parameterValues = new ArrayList();
        for (Parameter param : this.job.getParameters()) {
            parameterIdToValueMap.put(param.getParameterId(), param.getValue());
        }
        for (ToolDescription.ParameterDescription paramDescription : description.getParameters()) {
            if (parameterIdToValueMap.containsKey(paramDescription.getName())) {
                parameterValues.add(parameterIdToValueMap.get(paramDescription.getName()));
                continue;
            }
            throw new IllegalArgumentException("didn't find a value for parameter " + paramDescription.getName());
        }
        return JobMessageUtils.checkParameterSafety((JobMessage.ParameterSecurityPolicy)securityPolicy, (ToolDescription)description, parameterValues);
    }

    public String getUsername() {
        return null;
    }

    public JobCommand getJobCommand() {
        return this.jobCommand;
    }

    public UUID getSessionId() {
        return this.jobCommand.getSessionId();
    }

    public void setMetadata(HashMap<String, List<MetadataEntry>> metadataMap) {
        this.metadata = metadataMap;
    }

    public void preExecute(File jobWorkDir) {
        boolean phenodata = false;
        boolean phenodata2 = false;
        for (Input input : this.job.getInputs()) {
            if ("phenodata.tsv".equals(input.getInputId())) {
                phenodata = true;
            }
            if (!"phenodata2.tsv".equals(input.getInputId())) continue;
            phenodata2 = true;
        }
        try {
            RestPhenodataUtils.writePhenodata(jobWorkDir, this.metadata, phenodata, phenodata2);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write the phenodata", e);
        }
    }
}

