/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.auth.resource;

import fi.csc.chipster.auth.model.Token;
import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.auth.resource.AuthSecurityContext;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.exception.NotAuthorizedException;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.token.BasicAuthParser;
import fi.csc.microarray.auth.JaasAuthenticationProvider;
import fi.csc.microarray.config.ConfigurationLoader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Priority;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Provider
@Priority(value=1000)
public class AuthenticationRequestFilter
implements ContainerRequestFilter {
    private static final Logger logger = LogManager.getLogger();
    private HibernateUtil hibernate;
    private HashMap<String, String> serviceAccounts;
    private JaasAuthenticationProvider authenticationProvider;

    public AuthenticationRequestFilter(HibernateUtil hibernate, Config config) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        this.hibernate = hibernate;
        this.serviceAccounts = new HashMap();
        for (String service : Config.services) {
            this.serviceAccounts.put(service, config.getPassword(service));
        }
        this.authenticationProvider = new JaasAuthenticationProvider(false);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if ("OPTIONS".equals(requestContext.getMethod())) {
            return;
        }
        String authHeader = requestContext.getHeaderString("authorization");
        if (authHeader == null) {
            throw new NotAuthorizedException("no authorization header found");
        }
        BasicAuthParser parser = new BasicAuthParser(requestContext.getHeaderString("authorization"));
        AuthPrincipal principal = null;
        principal = "token".equals(parser.getUsername()) ? this.tokenAuthentication(parser.getPassword()) : this.passwordAuthentication(parser.getUsername(), parser.getPassword());
        AuthSecurityContext sc = new AuthSecurityContext(principal, requestContext.getSecurityContext());
        requestContext.setSecurityContext((SecurityContext)sc);
    }

    public AuthPrincipal tokenAuthentication(String tokenKey) {
        UUID uuid;
        this.getHibernate().beginTransaction();
        try {
            uuid = UUID.fromString(tokenKey);
        }
        catch (IllegalArgumentException e) {
            throw new ForbiddenException("tokenKey is not a valid UUID");
        }
        Token token = (Token)this.getHibernate().session().get(Token.class, (Serializable)uuid);
        if (token == null) {
            throw new ForbiddenException();
        }
        this.getHibernate().commit();
        return new AuthPrincipal(token.getUsername(), tokenKey, token.getRoles());
    }

    private AuthPrincipal passwordAuthentication(String username, String password) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        if (!username.trim().equals(username)) {
            throw new ForbiddenException("white space in username");
        }
        if (this.serviceAccounts.containsKey(username)) {
            if (this.serviceAccounts.get(username).equals(password)) {
                return new AuthPrincipal(username, this.getRoles(username));
            }
            throw new ForbiddenException("wrong password");
        }
        if (this.authenticationProvider.authenticate(username, password.toCharArray())) {
            return new AuthPrincipal(username, this.getRoles(username));
        }
        throw new ForbiddenException("wrong username or password");
    }

    public HashSet<String> getRoles(String username) {
        HashMap<String, String> usernameToRole = new HashMap<String, String>();
        usernameToRole.put("comp", "comp");
        usernameToRole.put("file-broker", "file-broker");
        usernameToRole.put("proxy", "proxy");
        usernameToRole.put("scheduler", "scheduler");
        usernameToRole.put("service-locator", "service-locator");
        usernameToRole.put("session-db", "session-db");
        usernameToRole.put("session-worker", "session-worker");
        String[] roles = Config.services.contains(username) ? new String[]{"password", "server", (String)usernameToRole.get(username)} : new String[]{"password", "client"};
        return new HashSet<String>(Arrays.asList(roles));
    }

    private HibernateUtil getHibernate() {
        return this.hibernate;
    }
}

