/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.auth;

import fi.csc.chipster.auth.model.Token;
import fi.csc.chipster.rest.CredentialsProvider;
import fi.csc.chipster.rest.StaticCredentials;
import fi.csc.chipster.rest.exception.LocalDateTimeContextResolver;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.hibernate.service.spi.ServiceException;

public class AuthenticationClient {
    private static Logger logger = LogManager.getLogger();
    private ServiceLocatorClient serviceLocator;
    private UUID token;
    private List<String> authenticationServiceUris;

    public AuthenticationClient(ServiceLocatorClient serviceLocator, String username, String password) {
        this.serviceLocator = serviceLocator;
        this.construct(username, password);
    }

    public AuthenticationClient(String authUri, String username, String password) {
        this.authenticationServiceUris = Arrays.asList(authUri);
        this.construct(username, password);
    }

    public AuthenticationClient(List<String> auths, String username, String password) {
        this.authenticationServiceUris = auths;
        this.construct(username, password);
    }

    private void construct(String username, String password) {
        List<String> auths = this.getAuths();
        if (auths.size() == 0) {
            throw new InternalServerErrorException("no auths registered to service locator");
        }
        for (String authUri : auths) {
            try {
                logger.info("get token from " + authUri);
                this.token = this.getToken(authUri, username, password);
                break;
            }
            catch (ServiceException e) {
                logger.warn("auth not available", (Throwable)e);
            }
        }
    }

    private UUID getToken(String authUri, String username, String password) {
        Client authClient = AuthenticationClient.getClient(username, password, true);
        WebTarget authTarget = authClient.target(authUri);
        Token serverToken = (Token)authTarget.path("tokens").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null, Token.class);
        return serverToken.getTokenKey();
    }

    private List<String> getAuths() {
        if (this.serviceLocator != null) {
            return this.serviceLocator.get("authentication-service");
        }
        return this.authenticationServiceUris;
    }

    public static Client getClient(String username, String password, boolean enableAuth) {
        Client c = ClientBuilder.newClient();
        if (enableAuth) {
            HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)username, (String)password);
            c.register((Object)feature);
        }
        c.register(LocalDateTimeContextResolver.class);
        return c;
    }

    public static Client getClient() {
        return AuthenticationClient.getClient(null, null, false);
    }

    public Client getAuthenticatedClient() {
        return AuthenticationClient.getClient("token", this.token.toString(), true);
    }

    public Token getDbToken(String tokenKey) {
        List<String> auths = this.getAuths();
        for (String authUri : auths) {
            try {
                Token dbToken = (Token)this.getAuthenticatedClient().target(authUri).path("tokens").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("chipster-token", (Object)tokenKey).get(Token.class);
                if (dbToken == null) continue;
                return dbToken;
            }
            catch (ServiceException e) {
                logger.warn("auth not available", (Throwable)e);
            }
            catch (NotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public UUID getToken() {
        return this.token;
    }

    public CredentialsProvider getCredentials() {
        return new StaticCredentials("token", this.token.toString());
    }
}

