package it.sauronsoftware.cron4j;

/**
 * A plain structure used by the scheduler to pair a runnable routine with its
 * scheduling pattern.
 * 
 * @author Carlo Pelliccia
 */
class Task {

	/**
	 * A counter for object instances.
	 */
	private static int counter = 0;

	/**
	 * The scheduling pattern of the task.
	 */
	private SchedulingPattern schedulingPattern;

	/**
	 * The runnable routine of the task.
	 */
	private Runnable runnable;

	/**
	 * The object auto-generated ID.
	 */
	private Object id;

	/**
	 * Builds a Task object.
	 * 
	 * @param schedulingPattern
	 *            The scheduling pattern of the task.
	 * @param runnable
	 *            The runnable routine of the task.
	 */
	public Task(SchedulingPattern schedulingPattern, Runnable runnable) {
		this.schedulingPattern = schedulingPattern;
		this.runnable = runnable;
		this.id = new Integer(++counter);
	}

	/**
	 * This method returns the runnable routine of the task.
	 * 
	 * @return The runnable routine of the task.
	 */
	public Runnable getRunnable() {
		return runnable;
	}

	/**
	 * This method returns the scheduling pattern of the task.
	 * 
	 * @return The scheduling pattern of the task.
	 */
	public SchedulingPattern getSchedulingPattern() {
		return schedulingPattern;
	}

	/**
	 * This method changes the scheduling pattern of the task.
	 * 
	 * @param schedulingPattern
	 *            The new scheduling pattern for the task.
	 */
	public void setSchedulingPattern(SchedulingPattern schedulingPattern) {
		this.schedulingPattern = schedulingPattern;
	}

	/**
	 * This method returns the object auto-generated ID.
	 * 
	 * @return The object auto-generated ID.
	 */
	public Object getId() {
		return id;
	}

}
