/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.activemq.transport.amqp.AmqpHeader;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.hawtbuf.Buffer;

public class AmqpWireFormat
implements WireFormat {
    public static final int DEFAULT_MAX_FRAME_SIZE = 0x100000;
    private int version = 1;
    private long maxFrameSize = 0x100000L;
    boolean magicRead = false;

    public ByteSequence marshal(Object command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream((OutputStream)baos);
        this.marshal(command, dos);
        dos.close();
        return baos.toByteSequence();
    }

    public Object unmarshal(ByteSequence packet) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(packet);
        DataInputStream dis = new DataInputStream((InputStream)stream);
        return this.unmarshal(dis);
    }

    public void marshal(Object command, DataOutput dataOut) throws IOException {
        if (command instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)command;
            if (dataOut instanceof OutputStream) {
                WritableByteChannel channel = Channels.newChannel((OutputStream)((Object)dataOut));
                channel.write(buffer);
            } else {
                while (buffer.hasRemaining()) {
                    dataOut.writeByte(buffer.get());
                }
            }
        } else {
            Buffer frame = (Buffer)command;
            frame.writeTo(dataOut);
        }
    }

    public Object unmarshal(DataInput dataIn) throws IOException {
        if (!this.magicRead) {
            Buffer magic = new Buffer(8);
            magic.readFrom(dataIn);
            this.magicRead = true;
            return new AmqpHeader(magic);
        }
        int size = dataIn.readInt();
        if ((long)size > this.maxFrameSize) {
            throw new AmqpProtocolException("Frame size exceeded max frame length.");
        }
        Buffer frame = new Buffer(size);
        frame.bigEndianEditor().writeInt(size);
        frame.readFrom(dataIn);
        frame.clear();
        return frame;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }
}

