/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class Strings {
    public static String delimit(Iterable<? extends Object> objects, String delimeter) {
        String result = "";
        boolean first = true;
        for (Object object : objects) {
            if (first) {
                result = object.toString();
                first = false;
                continue;
            }
            result = result + delimeter + object;
        }
        return result;
    }

    public static String repeat(String string, int times) {
        String result = "";
        for (int c = 0; c < times; ++c) {
            result = result + string;
        }
        return result;
    }

    public static String[] repeatToArray(String string, int times) {
        String[] result = new String[times];
        for (int c = 0; c < times; ++c) {
            result[c] = string;
        }
        return result;
    }

    public static String indent(String string, int spaces) {
        StringTokenizer st = new StringTokenizer(string, "\n");
        String result = "";
        while (st.hasMoreTokens()) {
            result = result + Strings.repeat(" ", spaces) + st.nextToken() + "\n";
        }
        return result;
    }

    public static String crop(String string, int length) {
        return string.length() > length ? string.substring(0, length) : string;
    }

    public static boolean isFloatNumber(String string) {
        Float v = null;
        try {
            v = Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return v != null;
    }

    public static boolean isIntegerNumber(String string) {
        Integer v = null;
        try {
            v = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return v != null;
    }

    public static boolean containsAnyOf(String toCompare, boolean caseSensitive, String ... strings) {
        if (!caseSensitive) {
            toCompare = toCompare.toLowerCase();
        }
        for (String string : strings) {
            if (!caseSensitive) {
                string = string.toLowerCase();
            }
            if (!toCompare.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyOf(String toCompare, boolean caseSensitive, String ... strings) {
        if (!caseSensitive) {
            toCompare = toCompare.toLowerCase();
        }
        for (String string : strings) {
            if (!caseSensitive) {
                string = string.toLowerCase();
            }
            if (!toCompare.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String toString(int value, int digitCount) {
        String digits;
        String prefix = "";
        if (value < 0) {
            prefix = prefix + "-";
            digits = "" + -value;
        } else {
            digits = "" + value;
        }
        while (digits.length() < digitCount) {
            digits = "0" + digits;
        }
        return prefix + digits;
    }

    public static String startWithUppercase(String string) {
        if (string.length() > 0) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public static String separateUppercaseChars(String string, String separator) {
        String result = "";
        char prev = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char current = string.charAt(i);
            if (Character.isUpperCase(current) && Character.isUpperCase(prev)) {
                result = result + separator;
            }
            result = result + current;
            prev = string.charAt(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeEmptyLinesFromBeginning(String s) throws IOException {
        String result;
        BufferedReader reader = new BufferedReader(new StringReader(s));
        StringBuilder builder = new StringBuilder("");
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty()) {
                    builder.append(line + "\n");
                    String l = reader.readLine();
                    while (l != null) {
                        builder.append(l + "\n");
                        l = reader.readLine();
                    }
                    break;
                }
                line = reader.readLine();
            }
        }
        finally {
            IOUtils.closeIfPossible(reader);
        }
        if (!((result = builder.toString()).length() <= 0 || s.endsWith("\n") || s.endsWith("\r") || s.endsWith("\r") || s.endsWith("\r\n"))) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String rightPad(String[] array, int width) {
        String line = "";
        for (String title : array) {
            line = line + StringUtils.rightPad((String)title, (int)width);
        }
        return line;
    }

    public static List<String> splitConsideringQuotes(String input, char delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        boolean inQuotes = false;
        for (int current = 0; current < input.length(); ++current) {
            boolean atLastChar;
            if (input.charAt(current) == '\"') {
                inQuotes = !inQuotes;
            }
            boolean bl = atLastChar = current == input.length() - 1;
            if (input.charAt(current) == delimiter && !inQuotes) {
                result.add(input.substring(start, current).replace("\"", ""));
                start = current + 1;
                continue;
            }
            if (!atLastChar) continue;
            result.add(input.substring(start).replace("\"", ""));
        }
        return result;
    }

    public static String toHumanReadable(long i) {
        return Strings.toHumanReadable(i, true, false);
    }

    public static String toRoundedHumanReadable(long i) {
        return Strings.toHumanReadable(i, true, true);
    }

    public static String toHumanReadable(long i, boolean returnZero, boolean round) {
        if (i == 0L) {
            if (returnZero) {
                return "0";
            }
            return "";
        }
        if (i < 0L) {
            return "" + i;
        }
        int pow = (int)Math.log10(i);
        String sym = "";
        if (pow >= 3) {
            sym = "k";
        }
        if (pow >= 6) {
            sym = "M";
        }
        if (pow >= 9) {
            sym = "G";
        }
        if (pow >= 12) {
            sym = "T";
        }
        int div = (int)Math.pow(10.0, pow - pow % 3);
        if (round) {
            String roundNumber = "" + i / (long)div + " " + sym;
            return roundNumber;
        }
        String roundNumber = "" + i / (long)div + sym;
        String remainder = Strings.toHumanReadable(i % (long)div, false, false);
        return roundNumber + " " + remainder;
    }
}

