/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.ParameterMessage;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

public class PayloadMessage
extends ParameterMessage {
    private static final Logger logger = Logger.getLogger(PayloadMessage.class);
    private static final String KEY_PAYLOAD_PREFIX = "payload_";
    private Map<String, String> payloads = new HashMap<String, String>();

    public PayloadMessage() {
    }

    public PayloadMessage(List<String> parameters) {
        super(parameters);
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        try {
            Enumeration names = from.getMapNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                logger.debug((Object)("examining " + name));
                if (!name.startsWith(KEY_PAYLOAD_PREFIX)) continue;
                String payloadName = name.substring(KEY_PAYLOAD_PREFIX.length());
                String id = from.getString(name);
                this.payloads.put(payloadName, id);
                logger.debug((Object)("Unmarshalled " + name + " -> " + payloadName + ", " + id));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        try {
            for (String name : this.payloadNames()) {
                String key = KEY_PAYLOAD_PREFIX + name;
                String idString = this.payloads.get(name);
                mapMessage.setString(key, idString);
                logger.debug((Object)("Marshalled " + name + " -> " + key + " " + idString));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addPayload(String payloadName, String payloadId) {
        this.payloads.put(payloadName, payloadId);
    }

    public String getPayload(String name) throws JMSException {
        if (this.payloads.containsKey(name)) {
            return this.payloads.get(name);
        }
        throw new IllegalArgumentException("No payload with name: " + name);
    }

    public Set<String> payloadNames() {
        return this.payloads.keySet();
    }

    public Map<String, String> getPayloads() {
        return this.payloads;
    }

    @Override
    public String toString() {
        return super.toString() + ", payload count: " + this.payloadNames().size();
    }
}

