/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.UrlListMessage;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class UrlListMessageListener
extends TempTopicMessagingListenerBase {
    private static final Logger logger = Logger.getLogger(UrlListMessageListener.class);
    private List<URL> urlList = null;
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        if (msg instanceof UrlListMessage) {
            UrlListMessage urlListMessage = (UrlListMessage)msg;
            this.urlList = urlListMessage.getUrlList();
            this.latch.countDown();
        }
    }

    public List<URL> waitForReply(long timeout, TimeUnit unit) {
        try {
            this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            logger.warn((Object)"interrupted while waiting for latch", (Throwable)e);
        }
        return this.urlList;
    }
}

