/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.DirectMessagingEndpoint;
import fi.csc.microarray.messaging.DirectMessagingListener;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.TempTopicMessagingListener;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import java.util.LinkedList;
import javax.jms.JMSException;

public class DirectMessagingTopic
extends MessagingTopic {
    private LinkedList<MessagingListener> listeners = new LinkedList();
    private DirectMessagingEndpoint endpoint;

    public DirectMessagingTopic(String topicName, MessagingTopic.AccessMode accessMode, DirectMessagingEndpoint endpoint) throws JMSException {
        super(null, topicName, MessagingTopic.Type.MOCK, MessagingTopic.AccessMode.WRITE, endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void sendMessage(ChipsterMessage message) throws JMSException {
        this.setUsername(message);
        for (MessagingListener listener : this.listeners) {
            if (listener instanceof DirectMessagingListener) {
                DirectMessagingListener directListener = (DirectMessagingListener)listener;
                directListener.onChipsterMessage(message, this.endpoint);
                continue;
            }
            listener.onChipsterMessage(message);
        }
    }

    private void setUsername(ChipsterMessage message) {
        if (this.endpoint.getUsername() != null) {
            message.setUsername(this.endpoint.getUsername());
        }
    }

    @Override
    protected void sendReplyableMessage(ChipsterMessage message, TempTopicMessagingListener replyListener, MessagingListener authenticationListener) throws JMSException {
        this.sendReplyableMessage(message, replyListener);
    }

    @Override
    public void setListener(MessagingListener listener) throws JMSException {
        this.listeners.add(listener);
    }

    @Override
    public void sendReplyableMessage(ChipsterMessage message, TempTopicMessagingListener replyListener) throws JMSException {
        DirectMessagingTopic replyTopic = new DirectMessagingTopic("temp topic", MessagingTopic.AccessMode.READ_WRITE, this.endpoint);
        replyTopic.setListener(replyListener);
        this.endpoint.mapReplyTopic(message, replyTopic);
        this.setUsername(message);
        this.sendMessage(message);
    }

    @Override
    public void removeListener() throws JMSException {
        throw new UnsupportedOperationException("not supported by DirectMessagingTopic");
    }
}

