/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import de.schlichtherle.truezip.file.TFile;
import fi.csc.microarray.filebroker.DbFile;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.filebroker.DerbyMetadataServer;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.filebroker.FileServer;
import fi.csc.microarray.filebroker.FileServerListener;
import fi.csc.microarray.filebroker.ServerSessionImportExportTool;
import fi.csc.microarray.messaging.DirectMessagingEndpoint;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class ExampleSessionUpdater
extends FileServerListener {
    private static final String EXAMPLE_SESSION_ARCHIVE = "all-example-sessions.tar";
    private static Logger logger = Logger.getLogger(ExampleSessionUpdater.class);
    private File exampleSessionDir;
    public DerbyMetadataServer metadataServer;
    private ServerSessionImportExportTool importExportTool;
    private FileServer fileServer;

    public ExampleSessionUpdater(FileServer fileServer, DerbyMetadataServer metadataServer, File exampleSessionDir) throws Exception {
        this.fileServer = fileServer;
        this.metadataServer = metadataServer;
        this.exampleSessionDir = exampleSessionDir;
        DirectMessagingEndpoint directEndpoint = new DirectMessagingEndpoint("example_session_owner");
        fileServer.addEndpoint(directEndpoint);
        this.importExportTool = new ServerSessionImportExportTool(directEndpoint);
        if (!this.exampleSessionDir.exists() && !this.exampleSessionDir.mkdir()) {
            throw new FileBrokerException("Creating example session directory failed: " + this.exampleSessionDir);
        }
        fileServer.addListener(this);
    }

    public void importExampleSessions() throws JMSException, SQLException, Exception {
        List<DbSession> dbSessionList = this.metadataServer.listPublicSessions();
        HashMap<String, DbSession> dbSessions = new HashMap<String, DbSession>();
        for (DbSession session : dbSessionList) {
            String basename = session.getBasename();
            if (basename == null) continue;
            dbSessions.put(basename, session);
        }
        logger.debug((Object)("searching example sessions from " + this.exampleSessionDir));
        HashMap<String, File> zipSessions = new HashMap<String, File>();
        for (File file : this.exampleSessionDir.listFiles()) {
            if (!this.isZipSession(file)) continue;
            String basename = this.importExportTool.filenameToBasename(file.getName());
            zipSessions.put(basename, file);
        }
        Iterator dbSessionIter = dbSessions.keySet().iterator();
        while (dbSessionIter.hasNext()) {
            String dbSessionBasename = (String)dbSessionIter.next();
            if (zipSessions.containsKey(dbSessionBasename)) continue;
            logger.info((Object)("found a server session  '" + dbSessionBasename + "', but no zip session with that name. Going to remove the server session"));
            this.fileServer.removeSession(((DbSession)dbSessions.get(dbSessionBasename)).getDataId());
            dbSessionIter.remove();
        }
        for (String zipSessionBasename : zipSessions.keySet()) {
            File zipSessionFile = (File)zipSessions.get(zipSessionBasename);
            DbSession dbSession = (DbSession)dbSessions.get(zipSessionBasename);
            boolean store = false;
            if (dbSession == null) {
                logger.debug((Object)("found a zip session '" + zipSessionBasename + "', but there is no server session with that name"));
                store = true;
            } else {
                Timestamp dbSessionCreated = this.getTimestamp(dbSession.getDataId());
                Timestamp zipSessionModified = this.getTimestamp(zipSessionFile);
                store = zipSessionModified.after(dbSessionCreated);
            }
            if (store) {
                logger.info((Object)("storing example session '" + zipSessionBasename + "'"));
                this.importExportTool.importSession(zipSessionFile);
                logger.debug((Object)"example session stored");
                continue;
            }
            logger.debug((Object)("example session '" + zipSessionBasename + "' is up-to-date"));
        }
    }

    private Timestamp getTimestamp(File file) {
        return new Timestamp(file.lastModified());
    }

    private Timestamp getTimestamp(String dataId) throws SQLException {
        DbFile dbSessionFile = this.metadataServer.fetchFile(dataId);
        return Timestamp.valueOf(dbSessionFile.getCreated());
    }

    public void exportServerSessionInBackground(final String sessionUuid, final String basename) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ExampleSessionUpdater.this.exportServerSession(sessionUuid, basename);
            }
        };
        new Thread(r).start();
    }

    public void removeZipSessionInBackground(final File file) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ExampleSessionUpdater.this.removeZipSession(file);
            }
        };
        new Thread(r).start();
    }

    public void exportServerSession(String sessionUuid, String basename) {
        try {
            File zipFile = this.basenameToFile(basename);
            this.removeIfExists(zipFile);
            this.importExportTool.exportSession(sessionUuid, zipFile);
            this.fixZipTimestamp(sessionUuid, zipFile);
            this.updateExampleSessionArchive();
        }
        catch (Exception e) {
            logger.error((Object)"session export failed", (Throwable)e);
        }
    }

    private void fixZipTimestamp(String sessionUuid, File zipFile) throws SQLException {
        Timestamp dbSessionCreated = this.getTimestamp(sessionUuid);
        Timestamp zipSessionModified = this.getTimestamp(zipFile);
        long dTime = zipSessionModified.getTime() - dbSessionCreated.getTime();
        if (dTime < 0L) {
            logger.error((Object)"server session is newer than a zip session exported from it");
            return;
        }
        long MAX_TIME_FIX = 60000L;
        if (dTime > MAX_TIME_FIX) {
            logger.error((Object)("exported zip session was " + dTime / 1000L + " seconds older than its server session"));
            return;
        }
        logger.debug((Object)("zip session was made " + dTime + " ms older"));
        zipFile.setLastModified(zipFile.lastModified() - dTime);
    }

    private void updateExampleSessionArchive() throws IOException {
        logger.debug((Object)"updating the archive of all example sessions");
        File archive = new File(this.exampleSessionDir, EXAMPLE_SESSION_ARCHIVE);
        archive.delete();
        for (File file : this.exampleSessionDir.listFiles()) {
            if (!this.isZipSession(file)) continue;
            TFile inputSession = new TFile(file);
            TFile outputSession = new TFile(archive, file.getName());
            inputSession.cp_rp((File)outputSession);
        }
        TFile.umount();
    }

    private boolean isZipSession(File file) {
        return file.getName().endsWith(".zip") && !EXAMPLE_SESSION_ARCHIVE.equals(file.getName());
    }

    private File basenameToFile(String basename) {
        return new File(this.exampleSessionDir, this.importExportTool.basenameToFileName(basename));
    }

    private String uuidToBasename(String uuid) throws SQLException {
        for (DbSession session : this.metadataServer.listPublicSessions()) {
            if (!uuid.equals(session.getDataId())) continue;
            return session.getBasename();
        }
        return null;
    }

    public void removeZipSession(File zipFile) {
        try {
            this.removeIfExists(zipFile);
            this.updateExampleSessionArchive();
        }
        catch (IOException e) {
            logger.error((Object)"removing example session failed ", (Throwable)e);
        }
    }

    private void removeIfExists(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void listen(FileServerListener.Event e) {
        if (!(e.getEndpoint() instanceof DirectMessagingEndpoint)) {
            FileServerListener.Event event;
            if (e instanceof FileServerListener.AfterStoreSessionReply && "example_session_owner".equals((event = (FileServerListener.AfterStoreSessionReply)e).getUsername())) {
                logger.info((Object)("example session " + ((FileServerListener.StoreSessionEvent)event).getSessionName() + " is being saved, exporting it also as a zip file"));
                this.exportServerSessionInBackground(event.getUuid(), ((FileServerListener.StoreSessionEvent)event).getSessionName());
            }
            if (e instanceof FileServerListener.BeforeRemoveSession && "example_session_owner".equals((event = (FileServerListener.BeforeRemoveSession)e).getUsername())) {
                logger.info((Object)"example session is being removed, removing also the zip file");
                try {
                    String basename = this.uuidToBasename(event.getUuid());
                    File file = this.basenameToFile(basename);
                    logger.info((Object)("remove example session: " + file.getName()));
                    this.removeZipSessionInBackground(file);
                }
                catch (SQLException ex) {
                    logger.error((Object)"removing example session failed ", (Throwable)ex);
                }
            }
        }
    }
}

