/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.filebroker.ChecksumException;
import fi.csc.microarray.filebroker.ContentLengthException;
import fi.csc.microarray.filebroker.Md5FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public class ChecksumInputStream
extends DigestInputStream {
    public static final String HTTP_CHECKSUM_KEY = "Etag";
    private boolean useChecksums;
    private URLConnection connection;
    private String checksum = null;
    private long bytes = 0L;

    public ChecksumInputStream(InputStream baseStream, boolean useChecksums, URLConnection connection) {
        super(baseStream, ChecksumInputStream.getDigestWithRuntimeException());
        this.useChecksums = useChecksums;
        super.on(useChecksums);
        this.connection = connection;
    }

    private static MessageDigest getDigestWithRuntimeException() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public ChecksumInputStream(InputStream baseStream, boolean useChecksums) {
        this(baseStream, useChecksums, null);
    }

    @Override
    public int read() throws IOException {
        this.checkState();
        int b = super.read();
        if (b != -1) {
            ++this.bytes;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkState();
        int bytesRead = super.read(b, off, len);
        if (bytesRead != -1) {
            this.bytes += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public int available() throws IOException {
        this.checkState();
        return super.available();
    }

    private void checkState() {
        if (this.useChecksums && this.checksum != null) {
            throw new IllegalStateException("use of InputStream is prevented after checksum calculation");
        }
    }

    public String getChecksum() {
        this.checkState();
        if (this.useChecksums) {
            this.checksum = DatatypeConverter.printHexBinary((byte[])super.getMessageDigest().digest()).toLowerCase();
            return this.checksum;
        }
        return null;
    }

    private String getRemoteChecksum() {
        if (this.connection == null) {
            throw new IllegalStateException("URLConnection wasn't given when this object was constructed: server checksum is unavailable");
        }
        return this.connection.getHeaderField(HTTP_CHECKSUM_KEY);
    }

    public String verifyChecksums() throws ChecksumException {
        if (this.useChecksums) {
            String localChecksum = this.getChecksum();
            Md5FileUtils.verify(this.getRemoteChecksum(), localChecksum);
            return localChecksum;
        }
        return null;
    }

    public void verifyContentLength(Long contentLength) throws ChecksumException, ContentLengthException {
        Md5FileUtils.verify(this.bytes, contentLength);
    }

    public Long getContentLength() {
        return this.bytes;
    }
}

