/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.stat;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.BasicFeature;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureProviderBase;
import fi.csc.microarray.databeans.features.NonexistingFeature;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.util.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

public class HierarchicalClusterProvider
extends FeatureProviderBase {
    @Override
    public Feature createFeature(String namePostfix, final DataBean bean) {
        if ("heatmap".equals(namePostfix)) {
            DataBean source = MicroarrayModule.getProperSource(bean);
            if (source != null) {
                return source.queryFeatures("/column/*").asFeature();
            }
            return new NonexistingFeature(bean, this);
        }
        if ("tree".equals(namePostfix)) {
            return new BasicFeature(bean, this){

                @Override
                public Iterable<String> asStrings() throws MicroarrayException {
                    BufferedReader reader = null;
                    String tree = "";
                    try {
                        reader = new BufferedReader(new InputStreamReader(Session.getSession().getDataManager().getContentStream(bean, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA)));
                        boolean first = true;
                        String line = reader.readLine();
                        while (line != null) {
                            tree = tree + line;
                            if (first && !line.contains(":") && !line.contains("(")) {
                                throw new MicroarrayException("cannot parse tree: " + Strings.crop(line, 20));
                            }
                            first = false;
                            line = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        throw new MicroarrayException(e);
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                    return Arrays.asList(tree);
                }
            };
        }
        throw new IllegalArgumentException("unknown postfix: " + namePostfix);
    }
}

