/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.cluster;

import fi.csc.microarray.cluster.ClusterBranchNode;
import fi.csc.microarray.cluster.ClusterLeafNode;
import fi.csc.microarray.cluster.ClusterNode;
import fi.csc.microarray.cluster.TreeParseException;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.LookaheadStringReader;
import java.io.File;

public class ClusterParser {
    private static final String SEPARATE_PARTS = ":";
    private static final String CLOSE_TREE = ";";
    private static final String SEPARATE_BRANCHES = ",";
    private static final String CLOSE_BRANCH = ")";
    private static final String OPEN_BRANCH = "(";
    private LookaheadStringReader reader;

    public ClusterParser(String tree) {
        this.reader = new LookaheadStringReader(tree.replace("\n", "").replace(" ", ""));
    }

    public ClusterBranchNode getTree() throws TreeParseException {
        if (this.reader == null) {
            throw new IllegalStateException("Tree already parsed, cannot reparse");
        }
        this.readAndCheck(OPEN_BRANCH);
        ClusterNode leftBranch = this.parseBranchOrLeaf();
        this.readAndCheck(SEPARATE_BRANCHES);
        ClusterNode rightBranch = this.parseBranchOrLeaf();
        this.readAndCheck(CLOSE_BRANCH);
        this.readAndCheck(CLOSE_TREE);
        this.reader = null;
        ClusterBranchNode rootBranch = new ClusterBranchNode();
        rootBranch.setLeftBranch(leftBranch);
        rootBranch.setRightBranch(rightBranch);
        return rootBranch;
    }

    private ClusterBranchNode parseBranch() throws TreeParseException {
        this.readAndCheck(OPEN_BRANCH);
        ClusterNode leftBranch = this.parseBranchOrLeaf();
        this.readAndCheck(SEPARATE_BRANCHES);
        ClusterNode rightBranch = this.parseBranchOrLeaf();
        this.readAndCheck(CLOSE_BRANCH);
        String length = this.parseLength();
        ClusterBranchNode branch = new ClusterBranchNode();
        branch.setLeftBranch(leftBranch);
        branch.setRightBranch(rightBranch);
        branch.setLength(length);
        return branch;
    }

    private ClusterNode parseBranchOrLeaf() throws TreeParseException {
        ClusterNode node = this.reader.lookahead().equals(OPEN_BRANCH) ? this.parseBranch() : this.parseLeaf();
        return node;
    }

    private ClusterLeafNode parseLeaf() throws TreeParseException {
        String gene = this.parseGene();
        String length = this.parseLength();
        ClusterLeafNode leaf = new ClusterLeafNode();
        leaf.setGene(gene);
        leaf.setLength(length);
        return leaf;
    }

    private String parseGene() {
        String gene = this.reader.readTo(SEPARATE_PARTS);
        return gene;
    }

    private String parseLength() throws TreeParseException {
        this.readAndCheck(SEPARATE_PARTS);
        String length = this.reader.readTo(SEPARATE_BRANCHES, CLOSE_BRANCH);
        return length;
    }

    private void readAndCheck(String s) throws TreeParseException {
        try {
            String r = this.reader.read();
            if (!r.equals(s)) {
                throw new TreeParseException("expected \"" + s + "\" but found \"" + r + "\"", this.reader);
            }
        }
        catch (StringIndexOutOfBoundsException se) {
            throw new TreeParseException("unexpected end of string", this.reader);
        }
    }

    public static void main(String[] args) throws Exception {
        String tree = Files.fileToString(new File("test.tre"));
        new ClusterParser(tree).getTree();
    }
}

