/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ScatterplotFileLineConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RegionTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ScatterplotTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;

public class BedTrackGroup
extends TrackGroup {
    private RegionTrack regionTrack;
    private ScatterplotTrack scatterplotTrack;
    private ScatterplotFileLineConversion dataThread;

    public BedTrackGroup(GBrowserView view, ScatterplotFileLineConversion dataThread, String title) {
        super(view);
        this.setSettingsEnabled(true);
        this.dataThread = dataThread;
        this.setName(title);
        this.addTracks();
    }

    private void addRegionTrack() {
        SeparatorTrack separator = new SeparatorTrack(Color.white, 20);
        separator.setView(this.view);
        this.addTrack(separator);
        this.regionTrack = new RegionTrack(GBrowserConstants.BED_COLOR);
        this.regionTrack.setView(this.view);
        this.regionTrack.addDataThread(this.dataThread);
        this.addTrack(this.regionTrack);
    }

    private void addScatterplotTrack() {
        Float min = this.dataThread.getMinScatterplotValue();
        Float max = this.dataThread.getMaxScatterplotValue();
        if (min == null) {
            min = Float.valueOf(0.0f);
        }
        if (max == null) {
            max = Float.valueOf(1.0f);
        }
        this.scatterplotTrack = new ScatterplotTrack(GBrowserConstants.BED_COLOR, 100, min.floatValue(), max.floatValue(), DataType.VALUE);
        this.scatterplotTrack.setMinSize(4);
        this.scatterplotTrack.setXAxisVisible(true);
        this.scatterplotTrack.setView(this.view);
        this.scatterplotTrack.addDataThread(this.dataThread);
        this.addTrack(this.scatterplotTrack);
    }

    @Override
    public void addTracks() {
        this.tracks.clear();
        this.getStatusAnimation().addDataThread(this.dataThread);
        if (!this.isMinimized()) {
            if (this.isShowMore()) {
                this.addScatterplotTrack();
            } else {
                this.addRegionTrack();
            }
        }
    }

    @Override
    public boolean isShowMorePossible() {
        return !this.isMinimized();
    }

    @Override
    public String getShowMoreName() {
        return "Show score";
    }
}

