/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BinarySearchIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.InMemoryIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSourceHttpTest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class IndexPerformanceTest {
    private static long time;
    private static long memoryUsage;

    @Test
    public void run() throws FileNotFoundException, MalformedURLException, IOException, URISyntaxException, GBrowserException {
        IndexPerformanceTest.checkLimits(null, null);
        File file = new File(RandomAccessLineDataSourceHttpTest.getLocalGtfUrl().toURI());
        DataUrl dataUrl = new DataUrl(file);
        InMemoryIndex memIndex = new InMemoryIndex(new LineDataSource(dataUrl), new GtfLineParser());
        IndexPerformanceTest.checkLimits(3000, 12);
        BinarySearchIndex searchIndex = new BinarySearchIndex(new RandomAccessLineDataSource(dataUrl), new GtfLineParser());
        IndexPerformanceTest.checkLimits(100, 16);
        Region chr1 = new Region(0L, Long.MAX_VALUE, new Chromosome("1"));
        IndexPerformanceTest.troughputTest(memIndex, chr1);
        IndexPerformanceTest.checkLimits(3000, 12);
        IndexPerformanceTest.troughputTest(searchIndex, chr1);
        IndexPerformanceTest.checkLimits(100, 10);
        IndexPerformanceTest.randomSeeks(memIndex);
        IndexPerformanceTest.checkLimits(500, 10);
        IndexPerformanceTest.randomSeeks(memIndex);
        IndexPerformanceTest.checkLimits(250, 10);
        IndexPerformanceTest.randomSeeks(searchIndex);
        IndexPerformanceTest.checkLimits(10000, 600);
        IndexPerformanceTest.randomSeeks(searchIndex);
        IndexPerformanceTest.checkLimits(5000, 600);
        IndexPerformanceTest.agreementTest(memIndex, searchIndex);
    }

    private static void checkLimits(Integer timeLimit, Integer memLimit) {
        long dTime = System.currentTimeMillis() - time;
        long dMemory = IndexPerformanceTest.getMemoryUsage() - memoryUsage;
        if (timeLimit != null) {
            Assert.assertTrue((String)("Task duration " + dTime + " ms exceeds the given limit " + timeLimit + " ms"), (dTime < (long)timeLimit.intValue() ? 1 : 0) != 0);
        }
        if (memLimit != null) {
            Assert.assertTrue((String)("Memory usage " + dMemory + " Mb exceeds the given limit " + memLimit + " Mb"), (dMemory < (long)memLimit.intValue() ? 1 : 0) != 0);
        }
        memoryUsage = IndexPerformanceTest.getMemoryUsage();
        time = System.currentTimeMillis();
    }

    private static String troughputTest(Index index, Region chr1) throws IOException, GBrowserException {
        long t = System.currentTimeMillis();
        long bytes = 0L;
        for (String line : index.getFileLines(chr1).values()) {
            bytes += (long)(line.length() + 1);
        }
        long dt = System.currentTimeMillis() - t;
        return "Bytes: " + bytes / 1024L / 1024L + " MB \tTime: " + dt + " ms \tBandwidth: " + (double)bytes / 1024.0 / 1024.0 / ((double)dt / 1000.0) + "MB/s";
    }

    private static Random randomSeeks(Index index) throws IOException, GBrowserException {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            Chromosome chr = new Chromosome("" + rand.nextInt(22));
            long start = rand.nextInt(200000000);
            long end = start + 100000L;
            Region region = new Region(start, end, chr);
            index.getFileLines(region);
        }
        return rand;
    }

    private static void agreementTest(InMemoryIndex index1, BinarySearchIndex index2) throws IOException, GBrowserException {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            Chromosome chr = new Chromosome("" + rand.nextInt(22));
            long start = rand.nextInt(200000000);
            long end = start + 100000L;
            Region region = new Region(start, end, chr);
            Collection<String> lines1 = index1.getFileLines(region).values();
            Collection<String> lines2 = index2.getFileLines(region).values();
            IndexPerformanceTest.testCompare(lines1, lines2, "\tRequest region: " + region);
        }
    }

    private static boolean testCompare(Collection<String> lines1, Collection<String> lines2, String details) {
        if (lines1.size() != lines2.size()) {
            Assert.fail((String)("Unequal line count: " + lines1.size() + ", " + lines2.size() + details));
        }
        Iterator<String> iter1 = lines1.iterator();
        Iterator<String> iter2 = lines2.iterator();
        while (iter1.hasNext()) {
            String line2;
            String line1 = iter1.next();
            if (line1.equals(line2 = iter2.next())) continue;
            Assert.fail((String)("Unequal lines" + details + "\n" + line1 + "\n" + line2));
        }
        return true;
    }

    private static long getMemoryUsage() {
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / 1024L / 1024L;
    }
}

