/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class SynonymReplace {
    public List<Synonym> list;

    public SynonymReplace(Synonym[] array) {
        this.list = Arrays.asList(array);
    }

    public SynonymReplace() {
        this.list = new LinkedList<Synonym>();
    }

    public String apply(String name) {
        for (Synonym synonym : this.list) {
            name = synonym.apply(name);
        }
        return name;
    }

    public String revoke(String name) {
        for (Synonym synonym : this.list) {
            name = synonym.revoke(name);
        }
        return name;
    }

    public List<Synonym> getSynonyms() {
        return this.list;
    }

    public void add(Synonym synonym) {
        this.list.add(synonym);
    }

    public static class Synonym {
        private String searchFor;
        private String replaceWith;

        public Synonym(String searchFor, String replaceWith) {
            this.searchFor = searchFor;
            this.replaceWith = replaceWith;
        }

        public String apply(String name) {
            if (this.searchFor.equals(name)) {
                return this.replaceWith;
            }
            return name;
        }

        public String revoke(String name) {
            if (this.replaceWith.equals(name)) {
                return this.searchFor;
            }
            return name;
        }

        public String getReplaceWith() {
            return this.replaceWith;
        }

        public String getSearchFor() {
            return this.searchFor;
        }
    }
}

