/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToCoverageConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToCoverageEstimateConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToDetailsConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.GtfToFeatureConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.IndexedFastaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GeneIndexActions;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedTabixToRegionConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ByteDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ChromosomeBinarySearch;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CnaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CnaLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CytobandConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.FileLineConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ScatterplotFileLineConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.SearchIndexConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.TsvLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.VcfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.SamBamUtils;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import net.sf.picard.reference.ChipsterIndexedFastaSequenceFile;

public class Interpretation {
    private TrackType type;
    private DataUrl primaryData;
    private DataUrl indexData;
    private String name;
    private CnaConversion cnaDataThread;
    private GtfToFeatureConversion gtfDataThread;
    private FileLineConversion vcfDataThread;
    private ScatterplotFileLineConversion bedLineDataThread;
    private FileLineConversion tsvDataThread;
    private TreeSet<Chromosome> chrNames;

    public Interpretation(TrackType type, DataUrl primaryData) {
        this.type = type;
        this.primaryData = primaryData;
    }

    public TrackType getType() {
        return this.type;
    }

    public void setType(TrackType type) {
        this.type = type;
    }

    public DataUrl getPrimaryData() {
        return this.primaryData;
    }

    public void setPrimaryData(DataUrl primaryData) {
        this.primaryData = primaryData;
    }

    public DataUrl getIndexData() {
        return this.indexData;
    }

    public void setIndexData(DataUrl indexData) {
        this.indexData = indexData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.primaryData.getName();
    }

    public static CytobandConversion getCytobandDataThread(GBrowser browser) {
        DataUrl cytobandUrl = browser.getAnnotationUrl(browser.getGenome(), AnnotationManager.AnnotationType.CYTOBANDS);
        if (cytobandUrl != null) {
            return new CytobandConversion(cytobandUrl, browser);
        }
        return null;
    }

    public static GeneIndexActions getGeneSearchDataThread(GBrowser browser) {
        AnnotationManager.Genome genome = browser.getGenome();
        GtfToFeatureConversion gtfDataThread = Interpretation.getAnnotationDataThread(browser);
        List<AnnotationManager.GenomeAnnotation> indexes = browser.getAnnotationManager().getAnnotations(genome, AnnotationManager.AnnotationType.SEARCH_INDEX);
        ArrayList<DataUrl> indexUrls = new ArrayList<DataUrl>();
        for (AnnotationManager.GenomeAnnotation index : indexes) {
            indexUrls.add(index.getUrl());
        }
        SearchIndexConversion searchIndexConversion = null;
        if (!indexUrls.isEmpty()) {
            searchIndexConversion = new SearchIndexConversion(indexUrls, browser);
        }
        if (searchIndexConversion != null || gtfDataThread != null) {
            return new GeneIndexActions(browser.getPlot().getDataView().getQueueManager(), gtfDataThread, searchIndexConversion);
        }
        return null;
    }

    public static GtfToFeatureConversion getAnnotationDataThread(GBrowser browser) {
        AnnotationManager.Genome genome = browser.getGenome();
        DataUrl gtfUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.GTF);
        DataUrl gtfTabixUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.GTF_TABIX);
        DataUrl gtfIndexUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.GTF_TABIX_INDEX);
        GtfToFeatureConversion gtfDataThread = null;
        if (gtfUrl != null) {
            gtfDataThread = new GtfToFeatureConversion(gtfUrl, null, browser);
        } else if (gtfTabixUrl != null && gtfIndexUrl != null) {
            gtfDataThread = new GtfToFeatureConversion(gtfTabixUrl, gtfIndexUrl, browser);
        }
        return gtfDataThread;
    }

    public static BedTabixToRegionConversion getRepeatDataThread(GBrowser browser) {
        AnnotationManager.Genome genome = browser.getGenome();
        DataUrl repeatUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REPEAT);
        DataUrl repeatIndexUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REPEAT_INDEX);
        if (repeatUrl != null && repeatIndexUrl != null) {
            return new BedTabixToRegionConversion(repeatUrl, repeatIndexUrl, browser);
        }
        return null;
    }

    public static IndexedFastaConversion getReferenceDataThread(GBrowser browser) {
        AnnotationManager.Genome genome = browser.getGenome();
        DataUrl fastaUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REFERENCE);
        DataUrl fastaIndexUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REFERENCE_INDEX);
        IndexedFastaConversion refSeqDataThread = null;
        if (fastaUrl != null && fastaIndexUrl != null) {
            refSeqDataThread = new IndexedFastaConversion(fastaUrl, fastaIndexUrl, browser);
        }
        return refSeqDataThread;
    }

    public IndexedFastaConversion getFastaDataThread(GBrowser browser) throws URISyntaxException, IOException {
        if (this.getType() == TrackType.REFERENCE) {
            IndexedFastaConversion fastaDataThread = new IndexedFastaConversion(this.getPrimaryData(), this.getIndexData(), browser);
            return fastaDataThread;
        }
        throw new IllegalStateException("requested DataThread is not compatible with the Interpreation type: " + (Object)((Object)this.getType()));
    }

    public BamToDetailsConversion getBamDetailsDataThread(GBrowser browser) throws URISyntaxException, IOException {
        if (this.getType() == TrackType.READS) {
            BamDataSource dataSource = new BamDataSource(this.getPrimaryData(), this.getIndexData());
            return new BamToDetailsConversion(dataSource, browser);
        }
        throw new IllegalStateException("requested DataThread is not compatible with the Interpreation type: " + (Object)((Object)this.getType()));
    }

    public BamToCoverageConversion getBamCoverageDataThread(GBrowser browser) throws URISyntaxException, IOException {
        if (this.getType() == TrackType.READS) {
            BamDataSource dataSource = new BamDataSource(this.getPrimaryData(), this.getIndexData());
            return new BamToCoverageConversion(dataSource, browser);
        }
        throw new IllegalStateException("requested DataThread is not compatible with the Interpreation type: " + (Object)((Object)this.getType()));
    }

    public BamToCoverageEstimateConversion getBamCoverageEstimateDataThread(GBrowser browser) throws URISyntaxException, IOException {
        if (this.getType() == TrackType.READS) {
            BamDataSource dataSource = new BamDataSource(this.getPrimaryData(), this.getIndexData());
            return new BamToCoverageEstimateConversion(dataSource, browser);
        }
        throw new IllegalStateException("requested DataThread is not compatible with the Interpreation type: " + (Object)((Object)this.getType()));
    }

    public ScatterplotFileLineConversion getBedLineDataThread(GBrowser browser) throws URISyntaxException, IOException, GBrowserException {
        if (this.getType() == TrackType.REGIONS) {
            if (this.bedLineDataThread == null) {
                this.bedLineDataThread = new ScatterplotFileLineConversion(this.getPrimaryData(), new BedLineParser(true), browser);
            }
            return this.bedLineDataThread;
        }
        throw new IllegalStateException("requested DataThread is not compatible with the Interpreation type: " + (Object)((Object)this.getType()));
    }

    public FileLineConversion getTsvDataThread(GBrowser browser) throws UnsortedDataException, URISyntaxException, IOException, GBrowserException {
        if ((this.getType() == TrackType.TSV || this.getType() == TrackType.TSV_WITH_ROW_ID) && this.tsvDataThread == null) {
            this.tsvDataThread = new FileLineConversion(this.getPrimaryData(), new TsvLineParser(this.getPrimaryData(), this.getType()), browser);
        }
        return this.tsvDataThread;
    }

    public FileLineConversion getVcfDataThread(GBrowser browser) throws UnsortedDataException, URISyntaxException, IOException, GBrowserException {
        if (this.getType() == TrackType.VCF) {
            if (this.vcfDataThread == null) {
                this.vcfDataThread = new FileLineConversion(this.getPrimaryData(), new VcfLineParser(), browser);
            }
            return this.vcfDataThread;
        }
        throw new IllegalStateException("requested DataThread is not compatible with the Interpreation type: " + (Object)((Object)this.getType()));
    }

    public GtfToFeatureConversion getGtfDataThread(GBrowser browser) {
        if (this.getType() == TrackType.GTF) {
            if (this.gtfDataThread == null) {
                this.gtfDataThread = new GtfToFeatureConversion(this.getPrimaryData(), null, browser);
            }
            return this.gtfDataThread;
        }
        throw new IllegalStateException("requested DataThread is not compatible with the Interpreation type: " + (Object)((Object)this.getType()));
    }

    public CnaConversion getCnaDataThread(GBrowser browser) throws URISyntaxException, IOException {
        if (this.getType() == TrackType.CNA) {
            if (this.cnaDataThread == null) {
                this.cnaDataThread = new CnaConversion(new RandomAccessLineDataSource(this.getPrimaryData()), browser);
            }
            return this.cnaDataThread;
        }
        throw new IllegalStateException("requested DataThread is not compatible with the Interpreation type: " + (Object)((Object)this.getType()));
    }

    public TreeSet<Chromosome> getChromosomeNames() throws URISyntaxException, IOException, UnsortedDataException, GBrowserException {
        boolean isCna;
        URL index;
        TreeSet<Chromosome> chromosomes = new TreeSet<Chromosome>();
        if (this.getType() == TrackType.READS) {
            URL bam = this.getPrimaryData().getUrl();
            index = this.getIndexData().getUrl();
            for (String string : SamBamUtils.readChromosomeNames(bam, index)) {
                chromosomes.add(new Chromosome(string));
            }
        }
        if (this.getType() == TrackType.REFERENCE) {
            URL fasta = this.getPrimaryData().getUrl();
            index = this.getIndexData().getUrl();
            ChipsterIndexedFastaSequenceFile picard = new ChipsterIndexedFastaSequenceFile(new ByteDataSource(new DataUrl(fasta, fasta.toString())), new LineDataSource(new DataUrl(index, index.toString())));
            for (String string : picard.getContigs()) {
                chromosomes.add(new Chromosome(string));
            }
        }
        boolean isBed = this.getType() == TrackType.REGIONS;
        boolean isVcf = this.getType() == TrackType.VCF;
        boolean isGtf = this.getType() == TrackType.GTF;
        boolean isTsv = this.getType() == TrackType.TSV || this.getType() == TrackType.TSV_WITH_ROW_ID;
        boolean bl = isCna = this.getType() == TrackType.CNA;
        if (isBed || isVcf || isGtf || isCna || isTsv) {
            DataUrl data = this.getPrimaryData();
            ChromosomeBinarySearch chrSearch = null;
            if (isBed) {
                chrSearch = new ChromosomeBinarySearch(data, new BedLineParser(true));
            } else if (isVcf) {
                chrSearch = new ChromosomeBinarySearch(data, new VcfLineParser());
            } else if (isGtf) {
                chrSearch = new ChromosomeBinarySearch(data, new GtfLineParser());
            } else if (isCna) {
                chrSearch = new ChromosomeBinarySearch(data, new CnaLineParser());
            } else if (isTsv) {
                chrSearch = new ChromosomeBinarySearch(data, new TsvLineParser(data, this.getType()));
            }
            this.chrNames = chrSearch.getChromosomes();
            chromosomes.addAll(this.chrNames);
        }
        return chromosomes;
    }

    public static enum TrackType {
        CYTOBANDS(false),
        GENES(false),
        TRANSCRIPTS(true),
        REFERENCE(true),
        REGIONS(true),
        READS(true),
        HIDDEN(false),
        VCF(true),
        GTF(true),
        CNA(true),
        TSV(true),
        TSV_WITH_ROW_ID(true);

        public boolean isToggleable;

        private TrackType(boolean toggleable) {
            this.isToggleable = toggleable;
        }
    }
}

