/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import java.util.LinkedHashSet;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConcisedValueCache {
    private static final int CACHE_MAX_SIZE = 1000;
    private TreeMap<BpCoord, Counts> coordinateOrder = new TreeMap();
    private LinkedHashSet<BpCoord> storageOrder = new LinkedHashSet();

    public SortedMap<BpCoord, Counts> subMap(BpCoord from, BpCoord to) {
        SortedMap<BpCoord, Counts> subMap = this.coordinateOrder.subMap(from, to);
        for (BpCoord coord : subMap.keySet()) {
            this.storageOrder.remove(coord);
            this.storageOrder.add(coord);
        }
        return subMap;
    }

    public void store(BpCoord bpCoord, int countForward, int countReverse) {
        this.coordinateOrder.put(bpCoord, new Counts(countForward, countReverse));
        this.storageOrder.add(bpCoord);
        this.shrink();
    }

    private void shrink() {
        while (this.coordinateOrder.size() > 1000) {
            BpCoord oldest = (BpCoord)this.storageOrder.iterator().next();
            this.storageOrder.remove(oldest);
            this.coordinateOrder.remove(oldest);
        }
    }

    public static class Counts {
        public Integer forwardCount;
        public Integer reverseCount;

        public Counts(int forwardCount, int reverseCount) {
            this.forwardCount = forwardCount;
            this.reverseCount = reverseCount;
        }
    }
}

