/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.selection.IntegratedSelectionManager;
import fi.csc.microarray.client.selection.SelectionEvent;
import fi.csc.microarray.client.visualisation.SelectionList;
import fi.csc.microarray.client.visualisation.TableAnnotationProvider;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.methods.ChipVisualisation;
import fi.csc.microarray.client.visualisation.methods.SelectableChartPanel;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.DefaultCategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ExpressionProfile
extends ChipVisualisation
implements PropertyChangeListener,
SelectableChartPanel.SelectionChangeListener {
    private LinkedList<ProfileRow> rows;
    private SelectableChartPanel selectableChartPanel;
    private JPanel paramPanel;
    private SelectionList list;
    private CategoryPlot plot;
    private DataBean data;
    private Set<Integer> selectedIndexes = new HashSet<Integer>();
    private static final float START_COLOR_R = 0.0f;
    private static final float START_COLOR_G = 0.0f;
    private static final float START_COLOR_B = 1.0f;
    private static final float MIDDLE_COLOR_R = 1.0f;
    private static final float MIDDLE_COLOR_G = 1.0f;
    private static final float MIDDLE_COLOR_B = 0.0f;
    private static final float END_COLOR_R = 1.0f;
    private static final float END_COLOR_G = 0.0f;
    private static final float END_COLOR_B = 0.0f;

    @Override
    public void initialise(VisualisationFrame frame) throws Exception {
        super.initialise(frame);
    }

    @Override
    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
            this.paramPanel.setLayout(new BorderLayout());
            this.list = new SelectionList();
            JTabbedPane tabPane = new JTabbedPane();
            tabPane.addTab("Selected", this.list);
            this.paramPanel.add((Component)tabPane, "Center");
        }
        return this.paramPanel;
    }

    private static Color getColor(float position) {
        float b;
        float g;
        float r;
        boolean beforeMiddle = position < 0.5f;
        float gradientPosition = beforeMiddle ? position * 2.0f : (position - 0.5f) * 2.0f;
        float invGradientPosition = 1.0f - gradientPosition;
        if (beforeMiddle) {
            r = 0.0f * invGradientPosition + 1.0f * gradientPosition;
            g = 0.0f * invGradientPosition + 1.0f * gradientPosition;
            b = 1.0f * invGradientPosition + 0.0f * gradientPosition;
        } else {
            r = 1.0f * invGradientPosition + 1.0f * gradientPosition;
            g = 1.0f * invGradientPosition + 0.0f * gradientPosition;
            b = 0.0f * invGradientPosition + 0.0f * gradientPosition;
        }
        return new Color(ExpressionProfile.limit(r), ExpressionProfile.limit(g), ExpressionProfile.limit(b));
    }

    private static float limit(float f) {
        return Math.max(0.0f, Math.min(1.0f, f));
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        this.data = data;
        this.application.addClientEventListener(this);
        JFreeChart chart = this.createProfileChart(this.createDataset(), this.rows, data.getName());
        this.updateSelectionsFromApplication(false);
        this.selectableChartPanel = new SelectableChartPanel(chart, this);
        return this.selectableChartPanel;
    }

    private CategoryDataset createDataset() throws MicroarrayException {
        TableAnnotationProvider annotationProvider = new TableAnnotationProvider(this.data);
        Table chips = this.data.queryFeatures("/column/chip.*").asTable();
        HashMap<String, String> sampleNameLookup = new HashMap<String, String>();
        for (String chip : chips.getColumnNames()) {
            String sampleName = this.data.queryFeatures("/phenodata/linked/describe/" + chip.substring("chip.".length())).asString();
            sampleNameLookup.put(chip, sampleName);
        }
        Table samples = this.data.queryFeatures("/column/*").asTable();
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.rows = new LinkedList();
        int rowNumber = 0;
        while (samples.nextRow()) {
            boolean firstSample = true;
            for (String sample : samples.getColumnNames()) {
                if (!sample.startsWith("chip.")) continue;
                if (firstSample) {
                    ProfileRow row = new ProfileRow();
                    row.value = Float.valueOf(samples.getFloatValue(sample));
                    row.series = rowNumber;
                    firstSample = false;
                    this.rows.add(row);
                }
                String sampleName = (String)sampleNameLookup.get(sample);
                String rowName = annotationProvider.getAnnotatedRowname(samples.getStringValue(" "));
                IndividualizedColumn column = new IndividualizedColumn(sample, sampleName);
                dataset.addValue((double)samples.getFloatValue(sample), (Comparable)((Object)rowName), (Comparable)column);
            }
            ++rowNumber;
        }
        return dataset;
    }

    private CategoryItemRenderer createRenderer(List<ProfileRow> rows) {
        DefaultCategoryItemRenderer renderer = new DefaultCategoryItemRenderer();
        renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        renderer.setShapesVisible(false);
        Collections.sort(rows);
        float position = 0.0f;
        float step = 1.0f / (float)rows.size();
        for (ProfileRow row : rows) {
            if (this.selectedIndexes.contains(row.series)) {
                renderer.setSeriesPaint(row.series, (Paint)Color.black);
            } else {
                row.color = ExpressionProfile.getColor(position);
                renderer.setSeriesPaint(row.series, (Paint)ExpressionProfile.getColor(position));
            }
            position += step;
        }
        if (this.list != null) {
            this.list.setSelectedRows(this.selectedIndexes, this, false, this.data);
        }
        return renderer;
    }

    public JFreeChart createProfileChart(CategoryDataset categoryDataset, List<ProfileRow> rows, String name) throws MicroarrayException {
        CategoryAxis categoryAxis = new CategoryAxis("sample");
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        categoryAxis.setUpperMargin(0.0);
        categoryAxis.setLowerMargin(0.0);
        NumberAxis valueAxis = new NumberAxis("expression");
        this.plot = new CategoryPlot(categoryDataset, categoryAxis, (ValueAxis)valueAxis, this.createRenderer(rows));
        this.plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart("Expression profile for " + name, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, false);
        return chart;
    }

    @Override
    public void selectionChanged(Rectangle2D.Double selection) {
        if (selection == null) {
            this.selectedIndexes.clear();
        } else {
            HashSet<Integer> newSelection = new HashSet<Integer>();
            CategoryDataset dataset = this.plot.getDataset();
            List colKeys = dataset.getColumnKeys();
            List rowKeys = dataset.getRowKeys();
            for (int x = 0; x < dataset.getColumnCount() - 1; ++x) {
                for (int y = 0; y < dataset.getRowCount(); ++y) {
                    Point2D.Double end;
                    Point2D.Double start = new Point2D.Double(x, (Double)dataset.getValue((Comparable)rowKeys.get(y), (Comparable)colKeys.get(x)));
                    Line2D.Double line = new Line2D.Double(start, end = new Point2D.Double(x + 1, (Double)dataset.getValue((Comparable)rowKeys.get(y), (Comparable)colKeys.get(x + 1))));
                    if (!selection.intersectsLine(line)) continue;
                    newSelection.add(y);
                }
            }
            for (Integer row : newSelection) {
                if (this.selectedIndexes.contains(row)) {
                    this.selectedIndexes.remove(row);
                    continue;
                }
                this.selectedIndexes.add(row);
            }
        }
        this.list.setSelectedRows(this.selectedIndexes, this, true, this.data);
        this.plot.setRenderer(this.createRenderer(this.rows));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof SelectionEvent && evt.getSource() != this && ((SelectionEvent)evt).getData() == this.data) {
            this.updateSelectionsFromApplication(false);
        }
    }

    protected void updateSelectionsFromApplication(boolean dispatchEvent) {
        IntegratedSelectionManager manager = this.application.getSelectionManager().getSelectionManager(this.data);
        this.selectedIndexes.clear();
        for (int i : manager.getSelectionAsRows()) {
            this.selectedIndexes.add(i);
        }
        this.list.setSelectedRows(this.selectedIndexes, this, dispatchEvent, this.data);
        this.plot.setRenderer(this.createRenderer(this.rows));
    }

    public static class IndividualizedColumn
    implements Comparable<IndividualizedColumn> {
        private String viewName;
        private String internalName;

        public IndividualizedColumn(String internalName, String viewName) {
            this.internalName = internalName;
            this.viewName = viewName;
        }

        @Override
        public int compareTo(IndividualizedColumn o) {
            return this.internalName.compareTo(o.internalName);
        }

        public String toString() {
            return this.viewName;
        }

        public boolean equals(Object o) {
            if (o instanceof IndividualizedColumn) {
                IndividualizedColumn ic = (IndividualizedColumn)o;
                return this.internalName.equals(ic.internalName);
            }
            return false;
        }

        public int hashCode() {
            return this.internalName.hashCode();
        }
    }

    public static class ProfileRow
    implements Comparable<ProfileRow> {
        int series;
        Float value;
        Color color;

        @Override
        public int compareTo(ProfileRow row) {
            return this.value.compareTo(row.value);
        }
    }
}

