/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.ClientFocusTraversalPolicy;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationToolBar;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXHyperlink;

public class DataDetails
extends Visualisation
implements FocusListener,
DocumentListener,
MouseListener {
    private final String PLEASE_ADD_NOTES = "(Click here to add your notes)";
    private JTextArea notesField;
    private JPanel panel;
    private static final Color BG = Color.white;
    public static final String COMMAND = "command";
    public static final String RENAME_COMMAND = "rename";
    public static final int LEFT_WIDTH = 450;
    public static final int INDENTION = 20;
    private List<DataBean> datas;
    private JTextArea titleField;
    private JScrollPane scroller;
    private Vector<JComponent> focusableLinks = new Vector();

    @Override
    public void initialise(VisualisationFrame frame) throws Exception {
        super.initialise(frame);
    }

    private JPanel getPanelBase() {
        return this.getPanelBase(null);
    }

    private JPanel getPanelBase(String layoutArgs) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout(layoutArgs));
        panel.setBackground(BG);
        return panel;
    }

    private Component createNotes() {
        if (Session.getSession().getPrimaryModule().notesVisibleAtStartup()) {
            this.notesField = new JTextArea();
            this.notesField.setEditable(true);
            this.notesField.setLineWrap(true);
            this.notesField.setWrapStyleWord(true);
            this.notesField.addFocusListener(this);
            this.notesField.getDocument().addDocumentListener(this);
            this.notesField.setRows(1);
            this.setNotes(this.datas.get(0).getNotes());
            this.setNotesActive(false);
            this.notesField.setEnabled(true);
            this.notesField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\u001b') {
                        DataDetails.this.endEditing();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
            return this.notesField;
        }
        return this.getPanelBase();
    }

    private Component createVisualisations() {
        JPanel panel = this.getPanelBase("wrap 1");
        List<VisualisationMethod> visualisations = VisualisationToolBar.getMethodsFor(this.datas);
        for (VisualisationMethod method : visualisations) {
            JXHyperlink link = new JXHyperlink();
            link.setBackground(new Color(0.95f, 0.95f, 0.95f));
            link.addMouseListener((MouseListener)new LinkMouseListener(link));
            link.setFocusPainted(false);
            link.setIcon((Icon)method.getIcon());
            link.setIconTextGap(16);
            link.addActionListener((ActionListener)new VisualisationStarter(method, Session.getSession().getApplication()));
            link.setText(method.getName());
            panel.add((Component)link, "width 300!, height 50!");
            this.focusableLinks.add((JComponent)link);
        }
        return panel;
    }

    private JTextArea createTitleTextArea(DataBean data, boolean isSingle) {
        this.titleField = new JTextArea(data.getName());
        this.titleField.setFont(this.titleField.getFont().deriveFont(this.titleField.getFont().getSize2D() * 1.5f));
        if (isSingle) {
            this.titleField.addFocusListener(this);
            this.titleField.getDocument().addDocumentListener(this);
            this.setTitleActive(false);
            this.titleField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n' || e.getKeyChar() == '\u001b') {
                        DataDetails.this.titleField.setText(DataDetails.this.titleField.getText().replace("\n", ""));
                        DataDetails.this.endEditing();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        } else {
            this.titleField.setEditable(false);
        }
        return this.titleField;
    }

    private void endEditing() {
        this.scroller.requestFocusInWindow();
    }

    private Component createDatasetPanel(List<DataBean> datas) {
        JPanel panel = this.getPanelBase("wrap 1");
        if (datas.size() == 1) {
            DataBean data = datas.get(0);
            panel.add((Component)this.createTitleTextArea(data, true), "growx");
            panel.add((Component)this.createSizeAndDateLabel(data), "gapx 20");
            panel.add(this.createNotes(), "gapx 20, growx");
            panel.add((Component)this.createHistoryLink(data), "gapx 20");
            panel.add(this.createToolLabel(data), ", gapy 20");
            this.createParameterTable(panel);
        } else {
            for (DataBean data : datas) {
                panel.add(this.createTitleTextArea(data, false));
                panel.add(this.createToolLabel(data));
            }
        }
        return panel;
    }

    private JLabel createSizeAndDateLabel(DataBean data) {
        JLabel label = new JLabel(this.getSizeText(data) + ", " + this.getDateText(data));
        return label;
    }

    private String getDateText(DataBean data) {
        return data.getDate().toString();
    }

    private String getSizeText(DataBean data) {
        String text = null;
        try {
            Long rowCount = Session.getSession().getDataManager().getFastRowCount(data);
            if (rowCount != null && rowCount < 1000L) {
                text = rowCount + " rows";
            }
        }
        catch (MicroarrayException e) {
            Session.getSession().getApplication().reportException(e);
        }
        if (text == null) {
            text = data.getSize() != null ? Strings.toRoundedHumanReadable(data.getSize()) + "B" : "Size unknown";
        }
        return text;
    }

    private JXHyperlink createHistoryLink(final DataBean data) {
        JXHyperlink link = new JXHyperlink();
        link.setText("Analysis history");
        link.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataDetails.this.application.showHistoryScreenFor(data);
            }
        });
        return link;
    }

    private Component createToolLabel(DataBean data) {
        JLabel toolLabel = new JLabel(this.getNameText(data));
        toolLabel.setFont(toolLabel.getFont().deriveFont(1));
        return toolLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent getVisualisation(List<DataBean> datas) throws Exception {
        DataDetails dataDetails = this;
        synchronized (dataDetails) {
            this.datas = datas;
            this.panel = this.getPanelBase("gapy 20");
            this.scroller = new JScrollPane(this.panel);
            return this.scroller;
        }
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return bean != null;
    }

    @Override
    public boolean canVisualise(List<DataBean> datas) throws MicroarrayException {
        return datas.size() > 0;
    }

    private String getNameText(DataBean data) {
        if (data != null) {
            return data.getOperationRecord().getFullName();
        }
        return null;
    }

    private JPanel createParameterTable(JPanel panel) {
        Collection<OperationRecord.ParameterRecord> params;
        int TOOL_WIDTH = 250;
        OperationRecord operationRecord = this.datas.get(0).getOperationRecord();
        if (operationRecord != null && (params = operationRecord.getParameters()) != null) {
            for (OperationRecord.ParameterRecord parameterRecord : params) {
                OperationDefinition tool = this.application.getOperationDefinition(operationRecord.getNameID().getID());
                String defaultValue = null;
                String valueString = null;
                if (tool != null) {
                    defaultValue = tool.getParameterDefaultValue(parameterRecord);
                    valueString = tool.getHumanReadableParameterValue(parameterRecord);
                } else {
                    valueString = parameterRecord.getValue();
                }
                JTextArea name = new JTextArea(parameterRecord.getNameID().getDisplayName());
                JTextArea value = new JTextArea(valueString);
                name.setLineWrap(true);
                value.setLineWrap(true);
                name.setWrapStyleWord(true);
                value.setWrapStyleWord(true);
                name.setEditable(false);
                value.setEditable(false);
                if (defaultValue != null && defaultValue.equals(parameterRecord.getValue())) {
                    value.setForeground(Color.gray);
                }
                panel.add((Component)name, "split 2, gapx 20, width 250");
                panel.add((Component)value, "growx, pushx, wrap");
            }
        }
        return panel;
    }

    private void setNotes(String text) {
        if (text == null || "".equals(text.trim())) {
            this.notesField.setText("(Click here to add your notes)");
        } else {
            this.notesField.setText(text);
        }
    }

    private String getNotesContent() {
        if ("(Click here to add your notes)".equals(this.notesField.getText())) {
            return "";
        }
        return this.notesField.getText();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getComponent() == this.notesField) {
            this.setNotesActive(true);
            if ("(Click here to add your notes)".equals(this.notesField.getText())) {
                this.notesField.setSelectionStart(0);
                this.notesField.setSelectionEnd(this.notesField.getText().length());
                this.notesField.setBorder(new LineBorder(Color.gray));
            }
        } else if (e.getComponent() == this.titleField) {
            this.setTitleActive(true);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getComponent() == this.notesField) {
            this.setNotes(this.datas.get(0).getNotes());
            this.setNotesActive(false);
        } else if (e.getComponent() == this.titleField) {
            this.setTitleActive(false);
            if ("".equals(this.titleField.getText().trim())) {
                this.titleField.setText(this.datas.get(0).getName());
            }
        }
    }

    private void setNotesActive(boolean active) {
        if (active) {
            this.notesField.setBorder(new LineBorder(Color.gray));
        } else {
            this.notesField.setBorder(new LineBorder(BG));
            this.notesField.setEnabled(false);
            this.notesField.setEnabled(true);
            this.notesField.setSelectionStart(0);
            this.notesField.setSelectionEnd(0);
        }
    }

    private void setTitleActive(boolean active) {
        if (active) {
            this.titleField.setBorder(new LineBorder(Color.gray));
        } else {
            this.titleField.setBorder(new LineBorder(BG));
            this.titleField.setEnabled(false);
            this.titleField.setEnabled(true);
            this.titleField.setSelectionStart(0);
            this.titleField.setSelectionEnd(0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fieldUpdated(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fieldUpdated(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fieldUpdated(e);
    }

    private void fieldUpdated(DocumentEvent e) {
        if (e.getDocument() == this.notesField.getDocument()) {
            this.setNotesActive(true);
            if (this.datas != null) {
                this.datas.get(0).setNotes(this.getNotesContent());
            }
        } else if (e.getDocument() == this.titleField.getDocument()) {
            this.setTitleActive(true);
            if (!"".equals(this.titleField.getText().trim())) {
                this.application.renameDataItem(this.datas.get(0), this.titleField.getText().trim());
            }
        }
    }

    @Override
    public boolean isForMultipleDatas() {
        return true;
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.endEditing();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void updateFocusTraversal(JComponent base) {
        Vector<Component> order = new Vector<Component>();
        order.addAll(this.focusableLinks);
        base.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                if (DataDetails.this.focusableLinks.size() > 0) {
                    ((JComponent)DataDetails.this.focusableLinks.get(0)).requestFocusInWindow();
                }
            }
        });
        base.setFocusCycleRoot(true);
        base.setFocusTraversalPolicy(new ClientFocusTraversalPolicy(order));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visualisationShown() {
        DataDetails dataDetails = this;
        synchronized (dataDetails) {
            this.panel.removeAll();
            this.panel.add(this.createDatasetPanel(this.datas), "gapx 20, aligny top, width 470");
            this.panel.add(this.createVisualisations(), "aligny top");
            this.panel.addMouseListener(this);
            this.scroller.setBorder(null);
            this.updateFocusTraversal(this.scroller);
            if (this.getFrame().getVariables() != null) {
                for (Visualisation.Variable variable : this.getFrame().getVariables()) {
                    if (!COMMAND.equals(variable.getName()) || !RENAME_COMMAND.equals(variable.getExpression())) continue;
                    this.titleField.requestFocusInWindow();
                    this.titleField.getCaret().setDot(this.titleField.getText().length());
                }
            }
        }
    }

    private class VisualisationStarter
    implements ActionListener {
        private VisualisationMethod method;
        private ClientApplication application;

        private VisualisationStarter(VisualisationMethod method, ClientApplication clientApplication) {
            this.method = method;
            this.application = clientApplication;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.application.setVisualisationMethod(this.method, null, DataDetails.this.datas, DataDetails.this.getFrame().getType());
        }
    }

    class LinkMouseListener
    implements MouseListener {
        private JXHyperlink link;

        public LinkMouseListener(JXHyperlink link) {
            this.link = link;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.link.setOpaque(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.link.setOpaque(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

