/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class VisualisationMethodRepository {
    private LinkedList<VisualisationMethod> visualisationMethods = new LinkedList();

    public void addVisualisationMethods(VisualisationMethod[] newMethods) {
        this.visualisationMethods.addAll(Arrays.asList(newMethods));
    }

    public List<VisualisationMethod> getVisualisationMethods() {
        return this.visualisationMethods;
    }

    public VisualisationMethod getDefaultVisualisationFor(DataBean dataBean) throws IOException, MicroarrayException {
        for (VisualisationMethod method : this.getOrderedDefaultCandidates()) {
            if (!method.isApplicableTo(dataBean)) continue;
            return method;
        }
        return null;
    }

    public Iterable<VisualisationMethod> getOrderedDefaultCandidates() {
        LinkedList<VisualisationMethod> orderedDefaultCandidates = new LinkedList<VisualisationMethod>();
        for (VisualisationMethod method : this.visualisationMethods) {
            if (method.getOrderNumber() < 0) continue;
            orderedDefaultCandidates.add(method);
        }
        Collections.sort(orderedDefaultCandidates, new VisualisationMethodOrderComparator());
        return orderedDefaultCandidates;
    }

    public static class VisualisationMethodOrderComparator
    implements Comparator<VisualisationMethod> {
        @Override
        public int compare(VisualisationMethod method1, VisualisationMethod method2) {
            return new Integer(method2.getOrderNumber()).compareTo(new Integer(method1.getOrderNumber()));
        }
    }
}

