/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.session.SessionLoader;
import fi.csc.microarray.client.session.SessionSaver;
import fi.csc.microarray.client.session.UserSession;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.QuotaExceededException;
import fi.csc.microarray.security.CryptoKey;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.Files;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class SessionManager {
    private Logger logger = Logger.getLogger(SessionManager.class);
    protected static final String ALIVE_SIGNAL_FILENAME = "i_am_alive";
    protected static final int SESSION_BACKUP_INTERVAL = 5000;
    private String sessionNotes;
    private String currentSessionName;
    private String currentRemoteSession;
    protected boolean unsavedChanges = false;
    protected boolean unbackuppedChanges = false;
    protected File aliveSignalFile;
    private LinkedList<File> deadDirectories = new LinkedList();
    private DataManager dataManager;
    private FileBrokerClient fileBrokerClient;
    private SessionManagerListener listener;

    public SessionManager(final DataManager dataManager, FileBrokerClient fileBrokerClient, SessionManagerListener listener) throws IOException {
        this.dataManager = dataManager;
        this.fileBrokerClient = fileBrokerClient;
        if (listener == null) {
            listener = new BasicSessionManagerListener();
        } else {
            this.listener = listener;
        }
        dataManager.addDataChangeListener(new DataChangeListener(){

            @Override
            public void dataChanged(DataChangeEvent event) {
                SessionManager.this.unsavedChanges = true;
                SessionManager.this.unbackuppedChanges = true;
            }
        });
        this.aliveSignalFile = new File(dataManager.getRepository(), ALIVE_SIGNAL_FILENAME);
        this.aliveSignalFile.createNewFile();
        this.aliveSignalFile.deleteOnExit();
        Timer timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionManager.this.aliveSignalFile.setLastModified(System.currentTimeMillis());
                if (SessionManager.this.unbackuppedChanges) {
                    File sessionFile = UserSession.findBackupFile(dataManager.getRepository(), true);
                    sessionFile.deleteOnExit();
                    try {
                        SessionManager.this.saveLightweightSession(sessionFile);
                    }
                    catch (Exception e1) {
                        SessionManager.this.logger.warn((Object)e1);
                    }
                }
                SessionManager.this.unbackuppedChanges = false;
            }
        });
        timer.setCoalesce(true);
        timer.setRepeats(true);
        timer.setInitialDelay(5000);
        timer.start();
    }

    public void loadLocalSession(File sessionFile, boolean isDataless) throws Exception {
        this.loadLocalSession(sessionFile, isDataless, null);
    }

    public void loadLocalSession(File sessionFile, boolean isDataless, Integer xOffset) throws Exception {
        SessionLoader sessionLoader = new SessionLoader(sessionFile, isDataless, this.dataManager);
        this.loadSession(sessionLoader, xOffset);
    }

    public void loadStorageSession(String sessionId) throws Exception {
        this.loadStorageSession(sessionId, null);
    }

    public void loadStorageSession(String sessionId, Integer xOffset) throws Exception {
        SessionLoader sessionLoader = new SessionLoader(sessionId, this.dataManager);
        this.loadSession(sessionLoader, xOffset);
    }

    private void loadSession(SessionLoader sessionLoader, Integer xOffset) throws Exception {
        sessionLoader.setXOffset(xOffset);
        sessionLoader.loadSession();
        this.sessionNotes = sessionLoader.getSessionNotes();
    }

    public void saveSession(File sessionFile) throws Exception {
        boolean metadataValid = false;
        SessionSaver sessionSaver = new SessionSaver(sessionFile, this.dataManager);
        sessionSaver.setSessionNotes(this.sessionNotes);
        metadataValid = sessionSaver.saveSession();
        if (!metadataValid) {
            String validationDetails = sessionSaver.getValidationErrors();
            throw new ValidationException(validationDetails);
        }
    }

    public void saveLightweightSession(File sessionFile) throws Exception {
        SessionSaver sessionSaver = new SessionSaver(sessionFile, this.dataManager);
        sessionSaver.setSessionNotes(this.sessionNotes);
        sessionSaver.saveLightweightSession();
    }

    public String printSession() {
        StringBuffer buffer = new StringBuffer();
        SessionSaver.dumpSession(this.dataManager.getRootFolder(), buffer);
        return buffer.toString();
    }

    public String saveStorageSession(String name) throws Exception {
        String sessionId = CryptoKey.generateRandom();
        SessionSaver sessionSaver = new SessionSaver(sessionId, this.dataManager);
        sessionSaver.setSessionNotes(this.sessionNotes);
        LinkedList<String> dataIds = sessionSaver.saveStorageSession();
        this.fileBrokerClient.saveRemoteSession(name, sessionId, dataIds);
        return sessionId;
    }

    public String saveFeedbackSession() throws Exception {
        String sessionId = CryptoKey.generateRandom();
        SessionSaver sessionSaver = new SessionSaver(sessionId, this.dataManager);
        sessionSaver.setSessionNotes(this.sessionNotes);
        sessionSaver.saveFeedbackSession();
        return sessionId;
    }

    public List<DbSession> listRemoteSessions() throws JMSException {
        return this.fileBrokerClient.listRemoteSessions();
    }

    public void setSession(File sessionFile, String sessionId) throws MalformedURLException, JMSException {
        if (sessionFile != null) {
            this.currentRemoteSession = null;
            String oldValue = this.currentSessionName;
            this.currentSessionName = sessionFile.getName().replace(".zip", "");
            this.listener.sessionChanged(new SessionChangedEvent(this, "session", oldValue, this.currentSessionName));
        } else if (sessionId != null) {
            String oldValue = this.currentRemoteSession;
            this.currentRemoteSession = sessionId;
            this.currentSessionName = this.getSessionName(this.listRemoteSessions(), sessionId);
            this.listener.sessionChanged(new SessionChangedEvent(this, "session", oldValue, this.currentRemoteSession));
        } else {
            String oldValue = this.currentRemoteSession != null ? this.currentRemoteSession : this.currentSessionName;
            this.currentRemoteSession = null;
            this.currentSessionName = null;
            this.listener.sessionChanged(new SessionChangedEvent(this, "session", oldValue, null));
        }
    }

    public String getSessionName() {
        return this.currentSessionName;
    }

    public String getSessionUuid(List<DbSession> sessions, String name) throws MalformedURLException {
        String sessionUuid = null;
        for (DbSession session : sessions) {
            if (session.getName() == null || !session.getName().equals(name)) continue;
            sessionUuid = session.getDataId();
            break;
        }
        return sessionUuid;
    }

    public String getSessionName(List<DbSession> sessions, String uuid) throws MalformedURLException {
        String name = null;
        for (DbSession session : sessions) {
            if (session.getDataId() == null || !session.getDataId().equals(uuid)) continue;
            name = session.getName();
            break;
        }
        return name;
    }

    public String getSessionNotes() {
        return this.sessionNotes;
    }

    public void setSessionNotes(String notes) {
        if (this.sessionNotes != null && !this.sessionNotes.equals(notes)) {
            this.unsavedChanges = true;
        }
        this.sessionNotes = notes;
    }

    public boolean isCurrentRemoteSession(String sessionUuid) {
        return this.currentRemoteSession != null && this.currentRemoteSession.equals(sessionUuid);
    }

    public boolean areCloudSessionsEnabled() {
        boolean conf = DirectoryLayout.getInstance().getConfiguration().getBoolean("client", "enable-cloud-sessions");
        boolean specialUser = "example_session_owner".equals(Session.getSession().getUsername());
        return conf || specialUser;
    }

    public void restoreSessionAndWait(File file) {
        this.loadSessionAndWait(file, null, true, true, false, 0);
    }

    public void loadSessionAndWait(File sessionFile, String sessionId, boolean isDataless, boolean clearDeadTempDirs, boolean isExampleSession) {
        this.loadSessionAndWait(sessionFile, sessionId, isDataless, clearDeadTempDirs, isExampleSession, null);
    }

    public void loadSessionAndWait(File sessionFile, String sessionId, boolean isDataless, boolean clearDeadTempDirs, boolean isExampleSession, Integer xOffset) {
        if (!isDataless && !UserSession.isValidSessionFile(sessionFile)) {
            Session.getSession().getApplication().showDialog("Could not open session file.", "The given file is not a valid session file.", "", DialogInfo.Severity.INFO, true);
            return;
        }
        boolean somethingToSave = this.dataManager.databeans().size() != 0;
        try {
            if (sessionFile != null) {
                this.loadLocalSession(sessionFile, isDataless);
            } else {
                this.loadStorageSession(sessionId);
            }
            this.setSession(sessionFile, sessionId);
        }
        catch (Exception e) {
            if (isExampleSession) {
                Session.getSession().getApplication().showDialog("Opening example session failed.", "Please restart " + Session.getSession().getPrimaryModule().getDisplayName() + " to update example session links or see the details for more information.", Exceptions.getStackTrace(e), DialogInfo.Severity.INFO, true, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, null);
            } else {
                Session.getSession().getApplication().showDialog("Opening session failed.", "Unfortunately the session could not be opened properly. Please see the details for more information.", Exceptions.getStackTrace(e), DialogInfo.Severity.WARNING, true, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, null);
            }
            this.logger.error((Object)"loading session failed", (Throwable)e);
        }
        this.unsavedChanges = somethingToSave;
        if (clearDeadTempDirs) {
            this.clearDeadTempDirectories();
        }
    }

    public boolean saveSessionAndWait(boolean isRemote, File localFile, String remoteSessionName) {
        try {
            String sessionId = null;
            if (isRemote) {
                sessionId = this.saveStorageSession(remoteSessionName);
            } else {
                this.saveSession(localFile);
            }
            this.setSession(localFile, sessionId);
            this.unsavedChanges = false;
            return true;
        }
        catch (ValidationException e) {
            this.listener.showDialog("Problem with saving the session", "All the datasets were saved successfully, but there were troubles with saving the session information about them. This means that there may be problems when trying to open the saved session file later on.\n\nIf you have important unsaved datasets in this session, it might be a good idea to export such datasets using the File -> Export functionality.", e.getMessage(), DialogInfo.Severity.WARNING, true, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN);
            return false;
        }
        catch (QuotaExceededException e) {
            this.listener.showDialog("Quota exceeded", "Saving session failed, because your disk space quota was exceeded.\n\nPlease contact server maintainers to apply for more quota, remove some old sessions to free more disk space or save the session on your computer using the File -> Save local session functionality. ", e.getMessage(), DialogInfo.Severity.WARNING, true, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN);
            return false;
        }
        catch (Exception e) {
            this.listener.showDialog("Saving session failed", "Unfortunately your session could not be saved. Please see the details for more information.\n\nIf you have important unsaved datasets in this session, it might be a good idea to export such datasets using the File -> Export functionality.", Exceptions.getStackTrace(e), DialogInfo.Severity.WARNING, true, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN);
            return false;
        }
    }

    public void clearSessionWithoutConfirming() throws MalformedURLException, JMSException {
        this.dataManager.deleteAllDataItems();
        this.setSessionNotes(null);
        this.setSession(null, null);
        this.unsavedChanges = false;
    }

    public boolean removeRemoteSession(String sessionUuid) throws JMSException {
        if (this.currentRemoteSession != null && this.currentRemoteSession.equals(sessionUuid) && !this.dataManager.databeans().isEmpty()) {
            this.listener.showDialog("Remove prevented", "You were trying to remove a cloud session that is your last saved session. Removal of this session is prevented, because it may be the only copy of your current datasets. If you want to keep the datasets, please save them as a sessions first. If you want to remove the datasets, please delete them before removing the cloud session.", null, DialogInfo.Severity.INFO, true, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN);
            return false;
        }
        this.fileBrokerClient.removeRemoteSession(sessionUuid);
        return true;
    }

    public boolean hasUnsavedChanges() {
        return this.unsavedChanges;
    }

    public void clearDeadTempDirectories() {
        try {
            for (File dir : this.deadDirectories) {
                Files.delTree(dir);
            }
        }
        catch (Exception e) {
            this.listener.reportException(e);
        }
        this.deadDirectories.clear();
    }

    public File checkTempDirectories() throws IOException {
        Iterable<File> tmpDirectories = this.dataManager.listAllRepositories();
        File mostRecentDeadSignalFile = null;
        for (File directory : tmpDirectories) {
            if (directory.equals(this.dataManager.getRepository())) continue;
            File aliveSignalFile = new File(directory, ALIVE_SIGNAL_FILENAME);
            long originalLastModified = aliveSignalFile.lastModified();
            boolean unsuitable = false;
            while (System.currentTimeMillis() - aliveSignalFile.lastModified() < 10000L) {
                if (UserSession.findBackupFile(directory, false) == null) {
                    unsuitable = true;
                    break;
                }
                if (aliveSignalFile.lastModified() != originalLastModified) {
                    unsuitable = true;
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            if (unsuitable) continue;
            this.deadDirectories.add(directory);
            File deadSignalFile = new File(directory, ALIVE_SIGNAL_FILENAME);
            if (UserSession.findBackupFile(directory, false) == null || mostRecentDeadSignalFile != null && mostRecentDeadSignalFile.lastModified() >= deadSignalFile.lastModified()) continue;
            mostRecentDeadSignalFile = deadSignalFile;
        }
        return mostRecentDeadSignalFile != null ? mostRecentDeadSignalFile.getParentFile() : null;
    }

    public static class SessionChangedEvent
    extends PropertyChangeEvent {
        public SessionChangedEvent(Object source, String propertyName, Object oldValue, Object newValue) {
            super(source, propertyName, oldValue, newValue);
        }
    }

    public class BasicSessionManagerListener
    implements SessionManagerListener {
        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility) {
            throw new RuntimeException(title + ": " + message + " (" + details + ")");
        }

        @Override
        public void reportException(Exception e) {
            throw new RuntimeException(e);
        }

        @Override
        public void sessionChanged(SessionChangedEvent e) {
        }
    }

    public static interface SessionManagerListener {
        public void showDialog(String var1, String var2, String var3, DialogInfo.Severity var4, boolean var5, ChipsterDialog.DetailsVisibility var6);

        public void reportException(Exception var1);

        public void sessionChanged(SessionChangedEvent var1);
    }

    public static class ValidationException
    extends Exception {
        public ValidationException(String validationDetails) {
            super(validationDetails);
        }
    }
}

