/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import de.schlichtherle.truezip.zip.ZipFile;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.NameID;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.session.NonStoppingValidationEventHandler;
import fi.csc.microarray.client.session.UserSession;
import fi.csc.microarray.client.session.schema2.DataType;
import fi.csc.microarray.client.session.schema2.FolderType;
import fi.csc.microarray.client.session.schema2.InputType;
import fi.csc.microarray.client.session.schema2.LinkType;
import fi.csc.microarray.client.session.schema2.LocationType;
import fi.csc.microarray.client.session.schema2.NameType;
import fi.csc.microarray.client.session.schema2.OperationType;
import fi.csc.microarray.client.session.schema2.ParameterType;
import fi.csc.microarray.client.session.schema2.SessionType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.util.IOUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.eclipse.jetty.io.WriterOutputStream;

public class SessionLoaderImpl2 {
    private static final Logger logger = Logger.getLogger(SessionLoaderImpl2.class);
    private DataManager dataManager;
    private File sessionFile;
    private String sessionId;
    private SessionType sessionType;
    private boolean isDatalessSession;
    private LinkedHashMap<String, DataFolder> folders = new LinkedHashMap();
    private HashMap<DataFolder, FolderType> folderTypes = new HashMap();
    private LinkedHashMap<String, DataBean> dataBeans = new LinkedHashMap();
    private HashMap<DataBean, DataType> dataTypes = new HashMap();
    private LinkedHashMap<String, OperationRecord> operationRecords = new LinkedHashMap();
    private HashMap<OperationRecord, OperationType> operationTypes = new HashMap();
    private ZipFile zipFile;
    private ZipInputStream zipStream;
    private Integer xOffset;
    private String sessionNotes;

    public SessionLoaderImpl2(File sessionFile, DataManager dataManager, boolean isDatalessSession) {
        this.sessionFile = sessionFile;
        this.sessionId = null;
        this.dataManager = dataManager;
        this.isDatalessSession = isDatalessSession;
    }

    public SessionLoaderImpl2(String sessionId, DataManager dataManager, boolean isDatalessSession) {
        this.sessionFile = null;
        this.sessionId = sessionId;
        this.dataManager = dataManager;
        this.isDatalessSession = isDatalessSession;
    }

    private InputStream getStreamOfZipEntry(String zipEntry) throws Exception {
        InputStream stream = null;
        if (this.sessionFile != null) {
            if (!this.sessionFile.exists()) {
                throw new IOException("session file does not exist: " + this.sessionFile);
            }
            this.zipFile = new ZipFile(this.sessionFile);
            stream = this.zipFile.getInputStream(zipEntry);
        } else if (this.sessionId != null) {
            ZipEntry entry;
            FileBrokerClient fileBrokerClient = Session.getSession().getServiceAccessor().getFileBrokerClient();
            ChecksumInputStream inputStream = fileBrokerClient.getInputStream(this.sessionId);
            this.zipStream = new ZipInputStream(inputStream);
            while ((entry = this.zipStream.getNextEntry()) != null) {
                if (!zipEntry.equals(entry.getName())) continue;
                stream = this.zipStream;
                break;
            }
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMetadata() throws Exception {
        try {
            InputStream metadataStream = this.getStreamOfZipEntry("session.xml");
            if (metadataStream == null) {
                throw new ZipException("session file corrupted, entry session.xml was missing");
            }
            Unmarshaller unmarshaller = UserSession.getJAXBContext().createUnmarshaller();
            unmarshaller.setSchema(UserSession.getSchema());
            NonStoppingValidationEventHandler validationEventHandler = new NonStoppingValidationEventHandler();
            unmarshaller.setEventHandler((ValidationEventHandler)validationEventHandler);
            this.sessionType = (SessionType)unmarshaller.unmarshal((Source)new StreamSource(metadataStream), SessionType.class).getValue();
            if (validationEventHandler.hasEvents()) {
                throw new JAXBException("Invalid session file:\n" + validationEventHandler.getValidationEventsAsString());
            }
        }
        finally {
            IOUtils.closeIfPossible(this.zipFile);
            IOUtils.closeIfPossible(this.zipStream);
        }
    }

    private void createFolders() {
        for (FolderType folderType : this.sessionType.getFolder()) {
            String name = folderType.getName();
            String id = folderType.getId();
            if (this.getDataItem(id) != null) {
                logger.warn((Object)("duplicate folder id: " + id + " , ignoring folder: " + name));
                continue;
            }
            DataFolder dataFolder = "0".equals(id) ? this.dataManager.getRootFolder() : this.dataManager.createFolder(name);
            this.folders.put(id, dataFolder);
            this.folderTypes.put(dataFolder, folderType);
        }
    }

    private void createDataBeans() {
        for (DataType dataType : this.sessionType.getData()) {
            DataBean dataBean;
            String id;
            block11: {
                String name = dataType.getName();
                id = dataType.getId();
                if (this.getDataItem(id) != null) {
                    logger.warn((Object)("duplicate data bean id: " + id + " , ignoring data bean: " + name));
                    continue;
                }
                String dataId = dataType.getDataId();
                if (dataId == null) {
                    logger.warn((Object)("could not load data bean: " + name + " due to missing data id"));
                    throw new RuntimeException("trying to load data without data id");
                }
                try {
                    dataBean = this.dataManager.createDataBean(name, dataId, false);
                    for (LocationType location : dataType.getLocation()) {
                        String urlString = location.getUrl();
                        URL url = null;
                        try {
                            url = new URL(urlString);
                        }
                        catch (MalformedURLException e) {
                            logger.warn((Object)("could not parse url: " + urlString + " for data bean: " + name));
                            continue;
                        }
                        if (DataManager.StorageMethod.LOCAL_SESSION_ZIP.toString().equals(location.getMethod()) && !this.isDatalessSession) {
                            url = new URL(this.sessionFile.toURI().toURL(), "#" + url.getRef());
                        }
                        this.dataManager.addContentLocationForDataBean(dataBean, DataManager.StorageMethod.valueOfConverted(location.getMethod()), url);
                    }
                    this.dataManager.setOrVerifyContentLength(dataBean, dataType.getSize());
                    this.dataManager.setOrVerifyChecksum(dataBean, dataType.getChecksum());
                    Integer x = dataType.getLayoutX();
                    Integer y = dataType.getLayoutY();
                    if (x == null || y == null) break block11;
                    if (this.xOffset != null) {
                        x = x + this.xOffset;
                    }
                    dataBean.setPosition(x, y);
                }
                catch (Exception e) {
                    Session.getSession().getApplication().reportExceptionThreadSafely(new Exception("error while opening file " + name, e));
                    logger.warn((Object)("could not create data bean: " + name));
                    continue;
                }
            }
            XMLGregorianCalendar xmlCalendar = dataType.getCreationTime();
            if (xmlCalendar != null) {
                dataBean.setCreationDate(xmlCalendar.toGregorianCalendar().getTime());
            }
            dataBean.setNotes(dataType.getNotes());
            dataBean.setContentType(this.dataManager.guessContentType(dataBean.getName()));
            this.dataBeans.put(id, dataBean);
            this.dataTypes.put(dataBean, dataType);
        }
    }

    private void createOperations() {
        for (OperationType operationType : this.sessionType.getOperation()) {
            String operationSessionId = operationType.getId();
            if (this.operationRecords.containsKey(operationSessionId)) {
                logger.warn((Object)("duplicate operation id: " + operationSessionId));
                continue;
            }
            OperationRecord operationRecord = new OperationRecord();
            operationRecord.setNameID(this.createNameID(operationType.getName()));
            operationRecord.setCategoryName(operationType.getCategory());
            String colorString = operationType.getCategoryColor();
            if (colorString != null) {
                operationRecord.setCategoryColor(Color.decode(colorString));
            }
            operationRecord.setModule(operationType.getModule());
            for (ParameterType parameterType : operationType.getParameter()) {
                operationRecord.addParameter(parameterType.getName().getId(), parameterType.getName().getDisplayName(), parameterType.getName().getDescription(), parameterType.getValue());
            }
            String sourceCodeFileName = operationType.getSourceCodeFile();
            if (sourceCodeFileName != null && !sourceCodeFileName.isEmpty()) {
                String sourceCode = null;
                try {
                    sourceCode = this.getSourceCode(sourceCodeFileName);
                }
                catch (Exception e) {
                    logger.warn((Object)("could not load source code from " + sourceCodeFileName));
                }
                operationRecord.setSourceCode(sourceCode);
            }
            ClientApplication application = Session.getSession().getApplication();
            OperationDefinition currentTool = null;
            if (application != null) {
                currentTool = application.getOperationDefinitionBestMatch(operationRecord.getNameID().getID(), operationRecord.getModule(), operationRecord.getCategoryName());
            }
            if (currentTool != null) {
                operationRecord.getNameID().setDisplayName(currentTool.getDisplayName());
                operationRecord.getNameID().setDescription(currentTool.getDescription());
                if (currentTool.getCategory().getModule() != null) {
                    operationRecord.setModule(currentTool.getCategory().getModule().getModuleName());
                }
                operationRecord.setCategoryName(currentTool.getCategoryName());
                operationRecord.setCategoryColor(currentTool.getCategory().getColor());
                for (OperationRecord.ParameterRecord parameterRecord : operationRecord.getParameters()) {
                    Parameter currentParameter = currentTool.getParameter(parameterRecord.getNameID().getID());
                    if (currentParameter == null) continue;
                    parameterRecord.getNameID().setDisplayName(currentParameter.getDisplayName());
                    parameterRecord.getNameID().setDescription(currentParameter.getDescription());
                }
            }
            this.operationRecords.put(operationSessionId, operationRecord);
            this.operationTypes.put(operationRecord, operationType);
        }
    }

    private void linkDataItemChildren(DataFolder parent) {
        for (String childId : this.folderTypes.get(parent).getChild()) {
            DataItem child = this.getDataItem(childId);
            if (child == null) {
                logger.warn((Object)("child with id: " + childId + " does not exist"));
                continue;
            }
            this.dataManager.connectChild(child, parent);
            if (!(child instanceof DataFolder)) continue;
            this.linkDataItemChildren((DataFolder)child);
        }
    }

    private void linkInputsToOperations() {
        for (OperationRecord operationRecord : this.operationRecords.values()) {
            for (InputType inputType : this.operationTypes.get(operationRecord).getInput()) {
                String dataId;
                String inputID = inputType.getData();
                if (inputID != null) {
                    DataBean inputBean = this.dataBeans.get(inputID);
                    if (inputBean.queryFeatures("/phenodata/").exists()) continue;
                    operationRecord.addInput(this.createNameID(inputType.getName()), inputBean);
                    continue;
                }
                if (inputType.getName().getId().equals("phenodata.tsv") || (dataId = inputType.getDataId()) == null) continue;
                operationRecord.addInput(this.createNameID(inputType.getName()), dataId);
            }
        }
    }

    private void linkOperationsToOutputs() {
        for (DataBean dataBean : this.dataBeans.values()) {
            String operationId = this.dataTypes.get(dataBean).getResultOf();
            OperationRecord operationRecord = null;
            if (operationId != null) {
                operationRecord = this.operationRecords.get(operationId);
            }
            if (operationRecord == null) {
                operationRecord = OperationRecord.getUnkownOperationRecord();
            }
            dataBean.setOperationRecord(operationRecord);
        }
    }

    private void linkDataBeans() {
        for (DataBean dataBean : this.dataBeans.values()) {
            for (LinkType linkType : this.dataTypes.get(dataBean).getLink()) {
                try {
                    DataBean targetBean;
                    String targetID = linkType.getTarget();
                    if (targetID == null || (targetBean = this.dataBeans.get(targetID)) == null) continue;
                    dataBean.addLink(DataBean.Link.valueOf(linkType.getType()), targetBean);
                }
                catch (Exception e) {
                    logger.warn((Object)"could not add link", (Throwable)e);
                }
            }
        }
    }

    private DataItem getDataItem(String id) {
        DataItem dataItem = this.folders.get(id);
        if (dataItem != null) {
            return dataItem;
        }
        return this.dataBeans.get(id);
    }

    private NameID createNameID(NameType name) {
        return new NameID(name.getId(), name.getDisplayName(), name.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSourceCode(String sourceCodeFileName) throws Exception {
        InputStream sourceCodeInputStream = null;
        StringWriter stringWriter = null;
        try {
            sourceCodeInputStream = this.getStreamOfZipEntry(sourceCodeFileName);
            stringWriter = new StringWriter();
            IOUtils.copy(sourceCodeInputStream, (OutputStream)new WriterOutputStream((Writer)stringWriter));
            stringWriter.flush();
        }
        finally {
            IOUtils.closeIfPossible(this.zipFile);
            IOUtils.closeIfPossible(this.zipStream);
            IOUtils.closeIfPossible(stringWriter);
        }
        return stringWriter.toString();
    }

    public void loadSession() throws Exception {
        this.parseMetadata();
        this.createFolders();
        this.createDataBeans();
        this.createOperations();
        this.linkOperationsToOutputs();
        this.dataManager.addTypeTagsAndVerifyContentLength(this.dataBeans.values());
        this.linkDataItemChildren(this.dataManager.getRootFolder());
        this.linkDataBeans();
        this.linkInputsToOperations();
        this.sessionNotes = this.sessionType.getNotes();
    }

    public void setXOffset(Integer xOffset) {
        this.xOffset = xOffset;
    }

    public String getSessionNotes() {
        return this.sessionNotes;
    }
}

