/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.screen;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.screen.ScreenBase;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.util.GeneralFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class HistoryScreen
extends ScreenBase
implements ActionListener,
CaretListener {
    private static final Dimension BUTTON_SIZE = new Dimension(100, 25);
    private static final ClientApplication application = Session.getSession().getApplication();
    private JFrame frame;
    private JTextArea textArea;
    private Map<String, JCheckBox> checkBoxes = new HashMap<String, JCheckBox>();
    private JButton saveButton;
    private JButton closeButton;
    private DataBean data;
    private JFileChooser chooser = null;

    public HistoryScreen() {
        this.frame = new JFrame("History");
        JPanel contentPane = new JPanel(new GridBagLayout());
        this.checkBoxes.put("title", new JCheckBox("Step title"));
        this.checkBoxes.put("name", new JCheckBox("Dataset name"));
        this.checkBoxes.put("date", new JCheckBox("Creation date"));
        this.checkBoxes.put("oper", new JCheckBox("Applied analysis tool"));
        this.checkBoxes.put("param", new JCheckBox("Parameters"));
        this.checkBoxes.put("notes", new JCheckBox("User notes"));
        this.checkBoxes.put("code", new JCheckBox("Source code"));
        for (JCheckBox box : this.checkBoxes.values()) {
            box.setSelected(true);
            box.addActionListener(this);
        }
        this.checkBoxes.get("notes").setSelected(false);
        this.checkBoxes.get("date").setSelected(false);
        this.checkBoxes.get("code").setSelected(false);
        this.checkBoxes.get("param").setEnabled(this.checkBoxes.get("oper").isSelected());
        this.checkBoxes.get("code").setEnabled(this.checkBoxes.get("oper").isSelected() && !application.isStandalone());
        this.saveButton = new JButton("Save...");
        this.saveButton.setPreferredSize(BUTTON_SIZE);
        this.saveButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.setPreferredSize(BUTTON_SIZE);
        this.closeButton.addActionListener(this);
        this.textArea = new JTextArea();
        this.textArea.setText(this.getHistoryText());
        this.textArea.setMargin(new Insets(2, 2, 2, 2));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.addCaretListener(this);
        JScrollPane textAreaScroller = new JScrollPane(this.textArea);
        textAreaScroller.setPreferredSize(new Dimension(500, 250));
        JLabel topLabel = new JLabel("Show for Datasets:");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets.set(10, 2, 1, 2);
        c.gridx = 0;
        c.gridy = 0;
        contentPane.add((Component)topLabel, c);
        c.insets.set(1, 2, 0, 10);
        c.gridwidth = 1;
        ++c.gridy;
        contentPane.add((Component)this.checkBoxes.get("title"), c);
        ++c.gridy;
        contentPane.add((Component)this.checkBoxes.get("name"), c);
        ++c.gridy;
        contentPane.add((Component)this.checkBoxes.get("date"), c);
        ++c.gridx;
        c.gridy = 1;
        contentPane.add((Component)this.checkBoxes.get("oper"), c);
        ++c.gridy;
        contentPane.add((Component)this.checkBoxes.get("param"), c);
        ++c.gridy;
        contentPane.add((Component)this.checkBoxes.get("code"), c);
        ++c.gridx;
        c.gridy = 1;
        c.insets.set(1, 2, 0, 2);
        contentPane.add((Component)this.checkBoxes.get("notes"), c);
        c.insets.set(10, 2, 1, 2);
        c.gridx = 0;
        c.gridy += 3;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        contentPane.add((Component)textAreaScroller, c);
        c.insets.set(2, 2, 2, 2);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        contentPane.add((Component)this.saveButton, c);
        ++c.gridx;
        c.anchor = 13;
        contentPane.add((Component)this.closeButton, c);
        this.frame.setContentPane(contentPane);
        this.frame.pack();
        this.frame.setResizable(true);
        this.frame.setLocationRelativeTo(null);
    }

    public void setData(DataBean data) {
        this.data = data;
        this.refreshText();
    }

    private void refreshText() {
        this.textArea.setText(this.getHistoryText());
    }

    public String getHistoryText() {
        String history = application.getHistoryText(this.data, this.checkBoxes.get("title").isSelected(), this.checkBoxes.get("name").isSelected(), this.checkBoxes.get("date").isSelected(), this.checkBoxes.get("oper").isSelected(), this.checkBoxes.get("code").isSelected(), this.checkBoxes.get("notes").isSelected(), this.checkBoxes.get("param").isSelected());
        this.saveButton.setEnabled(true);
        return history;
    }

    private boolean exportToText() {
        int ret;
        if (this.chooser == null) {
            this.chooser = ImportUtils.getFixedFileChooser();
            GeneralFileFilter filter = new GeneralFileFilter("Text Files", new String[]{"txt"});
            this.chooser.setFileFilter(filter);
        }
        if ((ret = this.chooser.showSaveDialog(null)) == 0) {
            File selectedFile = this.chooser.getSelectedFile();
            if (selectedFile.exists() && JOptionPane.showConfirmDialog(this.frame, "Really overwrite " + selectedFile.getName() + "?", "Save", 0) != 0) {
                return false;
            }
            try {
                String[] lines;
                PrintWriter writer = new PrintWriter(selectedFile);
                String text = this.textArea.getText();
                for (String line : lines = text.split("\n")) {
                    writer.print(line);
                    writer.println();
                }
                writer.flush();
                writer.close();
                return true;
            }
            catch (IOException e) {
                application.reportException(e);
                return false;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JCheckBox) {
            if (source == this.checkBoxes.get("oper")) {
                this.checkBoxes.get("param").setEnabled(this.checkBoxes.get("oper").isSelected());
                this.checkBoxes.get("code").setEnabled(this.checkBoxes.get("oper").isSelected() && !application.isStandalone());
            }
            this.textArea.setText(this.getHistoryText());
        } else if (source == this.saveButton) {
            if (this.exportToText()) {
                this.saveButton.setEnabled(false);
            }
        } else if (source == this.closeButton) {
            this.frame.dispose();
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.saveButton.setEnabled(true);
    }

    @Override
    public boolean hasFrame() {
        return this.frame != null;
    }

    @Override
    public JFrame getFrame() {
        return this.frame;
    }
}

