/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.ToolPanel;
import fi.csc.microarray.client.operation.parameter.InputFileComponent;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;

public class ToolParameterPanel
extends ParameterPanel {
    private JScrollPane scroller;
    private static final int LEFT_MARGIN = 10;
    private static final int TOP_MARGIN = 2;
    private ToolPanel parent;

    public ToolParameterPanel(Operation operation, ToolPanel parent) throws MicroarrayException {
        super(operation, new BorderLayout());
        this.parent = parent;
        JXTaskPaneContainer paneContainer = new JXTaskPaneContainer();
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setGap(0);
        paneContainer.setLayout((LayoutManager)verticalLayout);
        JPanel paramPane = new JPanel(new GridBagLayout());
        GridBagConstraints con = this.prepareBagConstraints();
        for (Parameter param : operation.getParameters()) {
            ParameterInputComponent component;
            if (param.isOptional()) {
                component = this.createInputComponent(param);
                this.addParameter(paramPane, component, component.getLabel(), con);
                continue;
            }
            component = this.createInputComponent(param);
            JLabel label = component.getLabel();
            label.setFont(label.getFont().deriveFont(label.getFont().getStyle() ^ 1));
            this.addParameter(paramPane, component, label, con);
        }
        paneContainer.add((Component)paramPane);
        JXTaskPane pane = new JXTaskPane();
        pane.setTitle("Input datasets");
        pane.setCollapsed(false);
        paramPane = new JPanel(new GridBagLayout());
        con = this.prepareBagConstraints();
        LinkedList<InputFileComponent> inputComponents = new LinkedList<InputFileComponent>();
        if (operation.getDefinition().getInputs().size() > 1) {
            for (OperationDefinition.InputDefinition input : operation.getDefinition().getInputs()) {
                InputFileComponent inputComponent;
                InputFileComponent inputFileComponent = inputComponent = new InputFileComponent(input, operation);
                inputFileComponent.getClass();
                inputComponent.setListener(inputFileComponent.new InputFileComponent.InputFileComponentListener(inputComponents));
                inputComponents.add(inputComponent);
                this.addParameter(paramPane, inputComponent, inputComponent.getLabel(), con);
            }
            pane.add((Component)paramPane);
            paneContainer.add(pane);
        }
        this.scroller = new JScrollPane((Component)paneContainer);
        this.scroller.setHorizontalScrollBarPolicy(31);
        paneContainer.setBackgroundPainter((Painter)new MattePainter((Paint)this.getBackground()));
        pane.getContentPane().setBackground(this.getBackground());
        ((JXPanel)pane.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        paneContainer.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.scroller, "Center");
    }

    private void addParameter(JPanel panel, JComponent component, JLabel label, GridBagConstraints con) {
        con.gridx = 0;
        ++con.gridy;
        con.insets.top = 2;
        con.insets.left = 10;
        con.fill = 2;
        panel.add((Component)label, con);
        con.gridx = 1;
        con.anchor = 13;
        con.fill = 0;
        panel.add((Component)component, con);
    }

    private GridBagConstraints prepareBagConstraints() {
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 1;
        con.weightx = 1.0;
        con.weighty = 0.0;
        con.anchor = 17;
        return con;
    }

    @Override
    public void setMessage(String message, Color color) {
        this.parent.setInfoText(message, color, true);
        this.parent.updateSuitability();
    }
}

