/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.parameter.EnumParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ToolParameterPanel;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.LinkedList;
import javax.swing.JFrame;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ParameterTest {
    private static ToolParameterPanel panel;
    private static Parameter paramMulti;
    private static Parameter paramSingle;

    @BeforeClass
    public static void prepareComponents() {
        ToolCategory category = new ToolCategory("Testational");
        OperationDefinition definition = new OperationDefinition("Testation id", null, category, "Testationing", false);
        try {
            SADLDescription.Name[] options = new SADLDescription.Name[]{SADLDescription.Name.createName("a"), SADLDescription.Name.createName("b")};
            String[] defaults = new String[]{"a"};
            Parameter p = Parameter.createInstance(SADLDescription.Name.createName("list"), SADLSyntax.ParameterType.ENUM, options, "This is list", "1", "1", defaults, false);
            Assert.assertFalse((boolean)p.isOptional());
            EnumParameter.SelectionOption[] optionsMulti = new EnumParameter.SelectionOption[]{new EnumParameter.SelectionOption("I'm worth clicking", "i"), new EnumParameter.SelectionOption("Click me", "m"), new EnumParameter.SelectionOption("Or me", "o")};
            LinkedList<EnumParameter.SelectionOption> defaultOptions = new LinkedList<EnumParameter.SelectionOption>();
            defaultOptions.add(optionsMulti[0]);
            defaultOptions.add(optionsMulti[2]);
            paramMulti = new EnumParameter("multi", "Enum parameter", "Enum parameter", optionsMulti, defaultOptions, 1, 2);
            definition.addParameter(paramMulti);
            EnumParameter.SelectionOption[] optionsSingle = new EnumParameter.SelectionOption[]{new EnumParameter.SelectionOption("I'm worth choosing", "i"), new EnumParameter.SelectionOption("Choose me", "m")};
            defaultOptions = new LinkedList();
            defaultOptions.add(optionsSingle[1]);
            paramSingle = new EnumParameter("single", "Enum parameter", "Enum parameter", optionsSingle, defaultOptions, 1, 1);
            definition.addParameter(paramSingle);
            DataBean[] dataBeans = new DataBean[]{};
            Operation operation = new Operation(definition, dataBeans);
            panel = new ToolParameterPanel(operation, null);
        }
        catch (MicroarrayException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void runTest() {
        Assert.assertEquals((long)panel.getComponentCount(), (long)1L);
        Assert.assertEquals((Object)paramMulti.getValue(), (Object)"i,o");
        Assert.assertEquals((Object)paramSingle.getValue(), (Object)"m");
    }

    private void testVisually() {
        JFrame frame = new JFrame("Test frame");
        frame.getContentPane().add(panel.getComponent(0), "Center");
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        ParameterTest test = new ParameterTest();
        try {
            ParameterTest.prepareComponents();
            test.runTest();
            test.testVisually();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

