/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.dataimport.ConversionModel;
import fi.csc.microarray.client.dataimport.ProgressInformator;
import fi.csc.microarray.client.dataimport.RunnableImportProcess;
import fi.csc.microarray.util.SystemMonitorUtil;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class DataParsingTest {
    private static final int MB = 0x100000;

    @Test
    public void testSmallSizedRealData() throws IOException {
        System.out.println("\n");
        System.out.println("Small sized real data (Rows: ~15000, Column: 4, Size: 384kb, Delimiter: Tab, Decimal separator: Dot)");
        System.out.println("Showing all rows and columns");
        System.out.println("===============================");
        long start = System.currentTimeMillis();
        ConversionModel model = new ConversionModel(null);
        model.setInputFile(new File("src/test/resources/affy_example.cel"));
        model.chopData(false, new TestInformator(0x1E00000L));
        System.out.println("Best suitable delimiter was: " + model.getDelim().getName());
        System.out.println("===============================");
        System.out.println("Parsing done. Total time: " + (System.currentTimeMillis() - start));
    }

    class TestInformator
    implements ProgressInformator {
        private long memoryLimit;
        private int max;

        public TestInformator(long memoryLimit) {
            this.memoryLimit = memoryLimit;
        }

        @Override
        public void destroyInformator() {
        }

        @Override
        public void initializeInformator() {
        }

        @Override
        public void setMaximumValue(int max) {
            this.max = max;
        }

        @Override
        public void setMessage(String message) {
            System.out.println("Job informator: " + message);
        }

        @Override
        public void setMinimunValue(int min) {
        }

        @Override
        public void setProcess(RunnableImportProcess process) {
        }

        @Override
        public void setValue(int state) {
            if (state % 10000 == 0 && state != 0) {
                System.out.println("Line: " + state + "   percents done: " + (int)((float)state / (float)this.max * 100.0f) + "%   memory usage: " + SystemMonitorUtil.getMemInfo());
            }
            Assert.assertTrue((String)("Memory limit exceeded. Limit: " + SystemMonitorUtil.bytesToMegas(this.memoryLimit) + " Mb, used " + SystemMonitorUtil.bytesToMegas(SystemMonitorUtil.getUsed())), (SystemMonitorUtil.getUsed() < this.memoryLimit ? 1 : 0) != 0);
        }

        @Override
        public void stopProcess() {
        }

        @Override
        public void setIndeterminate(boolean newValue) {
        }
    }
}

