/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.emboss;

import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.emboss.EmbossAnalysisHandler;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileBrokerClientMock;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import fi.csc.microarray.security.CryptoKey;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Random;
import javax.jms.JMSException;
import org.junit.Assert;
import org.junit.Test;

public class EmbossRoundtripTest {
    private static String path = "src/test/resources/";
    private boolean isResultOK = false;
    private ResultCallback resultCallback = new ResultCallback(){
        private FileBrokerClient fileBroker = null;

        @Override
        public FileBrokerClient getFileBrokerClient() throws Exception {
            if (this.fileBroker == null) {
                try {
                    this.fileBroker = new FileBrokerClientMock();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            return this.fileBroker;
        }

        @Override
        public File getWorkDir() {
            File jobDir = new File(path, "emboss-tmp");
            if (!jobDir.exists()) {
                jobDir.mkdir();
            }
            return jobDir;
        }

        @Override
        public void removeRunningJob(AnalysisJob job) {
        }

        @Override
        public void sendResultMessage(ChipsterMessage inputMessage, ResultMessage resultMessage) {
            if (resultMessage.getState() == JobState.COMPLETED) {
                EmbossRoundtripTest.this.isResultOK = true;
            }
        }

        @Override
        public boolean shouldSweepWorkDir() {
            return true;
        }
    };

    @Test
    public void testRoundtripValidation() throws Exception {
        JobMessage jobMessage = new JobMessage();
        jobMessage.setJobId("water-" + new Random().nextInt(1000));
        jobMessage.addParameter("110.0");
        jobMessage.addParameter("10.0");
        jobMessage.addParameter("Y");
        this.executeJob("water.acd", jobMessage);
        Assert.assertFalse((boolean)this.isResultOK);
    }

    @Test
    public void testRoundtripExecution() throws Exception {
        JobMessage jobMessage = new JobMessage();
        jobMessage.setJobId("water-" + new Random().nextInt(1000));
        jobMessage.addParameter("100.0");
        jobMessage.addParameter("10.0");
        jobMessage.addParameter("Y");
        FileInputStream firstInput = new FileInputStream(path + "sequences/human_adh6.fasta");
        FileInputStream secondInput = new FileInputStream(path + "sequences/funghi_adh6.fasta");
        String firstDataId = CryptoKey.generateRandom();
        String secondDataId = CryptoKey.generateRandom();
        this.resultCallback.getFileBrokerClient().addFile(firstDataId, FileBrokerClient.FileBrokerArea.CACHE, firstInput, -1L, null);
        this.resultCallback.getFileBrokerClient().addFile(secondDataId, FileBrokerClient.FileBrokerArea.CACHE, secondInput, -1L, null);
        jobMessage.addPayload("asequence", firstDataId);
        jobMessage.addPayload("bsequence", secondDataId);
        this.executeJob("water.acd", jobMessage);
        Assert.assertTrue((boolean)this.isResultOK);
    }

    private void executeJob(String acdFileName, JobMessage jobMessage) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("externalToolPath", "/opt/chipster/tools");
        params.put("toolPath", "/EMBOSS-6.2.0/emboss");
        params.put("descriptionPath", "/EMBOSS-6.2.0/emboss/acd");
        EmbossAnalysisHandler analysisHandler = new EmbossAnalysisHandler(params);
        ToolDescription description = analysisHandler.handle(null, acdFileName, new HashMap<String, String>());
        AnalysisJob analysisJob = analysisHandler.createAnalysisJob(jobMessage, description, this.resultCallback);
        analysisJob.run();
    }

    public static void main(String[] args) throws Exception {
        EmbossRoundtripTest test = new EmbossRoundtripTest();
        test.testRoundtripValidation();
        test.testRoundtripExecution();
        System.exit(0);
    }
}

