/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.emboss;

import fi.csc.microarray.analyser.emboss.ACDDescription;
import fi.csc.microarray.analyser.emboss.ACDParameter;
import fi.csc.microarray.description.GenericInputTypes;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLSyntax;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;

public class ACDToSADL {
    public static final String OUTPUT_TYPE_PREFIX = "chipster_output_type_";

    public static SADLDescription convert(ACDDescription acd, String id) {
        SADLDescription sadl = new SADLDescription(SADLDescription.Name.createName(id, acd.getName()), acd.getDescription());
        LinkedList<ACDParameter> params = acd.getParameters();
        for (ACDParameter param : params) {
            SADLParameterCreator.createAndAdd(param, sadl);
        }
        for (ACDParameter param : acd.getOutputParameters()) {
            if (!param.getType().equals("seqout") && !param.getType().equals("seqoutall") && !param.getType().equals("seqoutset") && !param.getType().equals("align")) continue;
            SADLDescription.Name[] fieldValues = new SADLDescription.Name[]{SADLDescription.Name.createName("<undefined>", "Default"), SADLDescription.Name.createName("fasta", "FASTA"), SADLDescription.Name.createName("ncbi", "NCBI"), SADLDescription.Name.createName("clustal", "ClustalW"), SADLDescription.Name.createName("phylip", "Phylip"), SADLDescription.Name.createName("fastq", "FASTQ"), SADLDescription.Name.createName("sam", "SAM"), SADLDescription.Name.createName("bam", "BAM")};
            SADLDescription.Parameter parameter = new SADLDescription.Parameter(SADLDescription.Name.createName(OUTPUT_TYPE_PREFIX + param.getName(), "Output type for " + param.getName()), SADLSyntax.ParameterType.ENUM, fieldValues, "1", "1", "<undefined>", "Choose format for output file");
            parameter.setOptional(true);
            sadl.addParameter(parameter);
        }
        return sadl;
    }

    public static void main(String[] args) throws IOException {
        File input = null;
        if (args.length >= 1) {
            input = new File(args[0]);
        }
        if (input == null || !input.exists()) {
            System.out.println("ACD to SADL converter");
            System.out.println("Usage: ACDToSADL <input.acd> [<output.R>]");
            System.out.println("Arguments:");
            System.out.println("    <input.acd>     acd file to convert");
            System.out.println("Optional arguments:");
            System.out.println("    <output.R>      save conversion output to this file");
            return;
        }
        File output = args.length >= 2 ? new File(args[1]) : (input.getName().endsWith(".acd") ? new File(input.getName().replace(".acd", ".R")) : new File(input.getName() + ".R"));
        ACDDescription acdDescription = new ACDDescription(input);
        SADLDescription sadlDescription = ACDToSADL.convert(acdDescription, output.getName());
        FileUtils.writeStringToFile((File)output, (String)sadlDescription.toString());
        System.out.println("SADL saved to " + output);
    }

    public static class SADLParameterCreator {
        public static void createAndAdd(ACDParameter acdParam, SADLDescription internalRepr) {
            SADLDescription.Parameter param = SADLParameterCreator.createParameter(acdParam);
            if (param != null) {
                internalRepr.addParameter(param);
                return;
            }
            SADLDescription.Input input = SADLParameterCreator.createInput(acdParam);
            if (input != null) {
                internalRepr.addInput(input);
                return;
            }
            SADLDescription.Output output = SADLParameterCreator.createOutput(acdParam);
            if (output != null) {
                internalRepr.addOutput(output);
            }
        }

        public static SADLDescription.Parameter createParameter(ACDParameter param) {
            String fieldType = param.getType();
            String fieldName = param.getName();
            Integer type = ACDParameter.detectParameterGroup(fieldType.toLowerCase());
            HashMap<String, SADLSyntax.ParameterType> typeMap = new HashMap<String, SADLSyntax.ParameterType>();
            typeMap.put("array", SADLSyntax.ParameterType.STRING);
            typeMap.put("float", SADLSyntax.ParameterType.DECIMAL);
            typeMap.put("integer", SADLSyntax.ParameterType.INTEGER);
            typeMap.put("string", SADLSyntax.ParameterType.STRING);
            typeMap.put("range", SADLSyntax.ParameterType.STRING);
            typeMap.put("boolean", SADLSyntax.ParameterType.ENUM);
            typeMap.put("toggle", SADLSyntax.ParameterType.ENUM);
            typeMap.put("list", SADLSyntax.ParameterType.ENUM);
            typeMap.put("selection", SADLSyntax.ParameterType.ENUM);
            String fieldDefault = null;
            String fieldMin = null;
            String fieldMax = null;
            if (param.attributeIsEvaluated("default").booleanValue() && !param.getAttribute("default").equals("")) {
                fieldDefault = param.getAttribute("default");
            }
            if (param.attributeIsEvaluated("minimum").booleanValue()) {
                fieldMin = param.getAttribute("minimum");
            }
            if (param.attributeIsEvaluated("maximum").booleanValue()) {
                fieldMax = param.getAttribute("maximum");
            }
            String fieldHelp = param.getAttribute("help");
            String fieldInfo = param.getAttribute("information");
            if (fieldHelp == null || fieldHelp == "") {
                fieldHelp = param.getAttribute("information");
            }
            if (fieldHelp != null) {
                fieldHelp = fieldHelp.replaceAll("\n", "");
            }
            SADLDescription.Entity sadlParam = null;
            if (fieldType.equals("boolean") || fieldType.equals("toggle")) {
                SADLDescription.Name[] fieldOptions = new SADLDescription.Name[]{SADLDescription.Name.createName("<undefined>", " "), SADLDescription.Name.createName("Y", "Yes"), SADLDescription.Name.createName("N", "No")};
                if (fieldDefault == null) {
                    fieldDefault = "<undefined>";
                }
                sadlParam = new SADLDescription.Parameter(SADLDescription.Name.createName(fieldName, fieldInfo), (SADLSyntax.ParameterType)((Object)typeMap.get(fieldType)), fieldOptions, null, null, fieldDefault, fieldHelp);
            } else if (type == ACDParameter.PARAM_GROUP_SIMPLE) {
                sadlParam = new SADLDescription.Parameter(SADLDescription.Name.createName(fieldName, fieldInfo), (SADLSyntax.ParameterType)((Object)typeMap.get(fieldType)), null, fieldMin, fieldMax, fieldDefault, fieldHelp);
            } else if (type == ACDParameter.PARAM_GROUP_LIST) {
                int i;
                HashMap<String, String> fieldOptions = param.getList();
                LinkedList<String> fieldValueList = new LinkedList<String>(fieldOptions.values());
                SADLDescription.Name[] fieldValues = new SADLDescription.Name[fieldValueList.size()];
                String[] fieldDefaults = param.getDefaults();
                for (i = 0; i < fieldDefaults.length; ++i) {
                    if (fieldOptions.keySet().contains(fieldDefaults[i])) continue;
                    for (String key : fieldOptions.keySet()) {
                        if (!fieldOptions.get(key).equals(fieldDefaults[i])) continue;
                        fieldDefaults[i] = key;
                    }
                }
                i = 0;
                for (String key : fieldOptions.keySet()) {
                    fieldValues[i] = SADLDescription.Name.createName(key, fieldOptions.get(key));
                    ++i;
                }
                sadlParam = new SADLDescription.Parameter(SADLDescription.Name.createName(fieldName, fieldInfo), (SADLSyntax.ParameterType)((Object)typeMap.get(fieldType)), fieldValues, fieldMin, fieldMax, fieldDefaults, fieldHelp);
            }
            if (sadlParam != null) {
                sadlParam.setOptional(param.isRequired() == false);
            }
            return sadlParam;
        }

        public static SADLDescription.Input createInput(ACDParameter param) {
            String fieldType = param.getType();
            String fieldName = param.getName();
            Integer type = ACDParameter.detectParameterGroup(fieldType.toLowerCase());
            if (type == ACDParameter.PARAM_GROUP_INPUT && param.isRequired().booleanValue()) {
                SADLDescription.Input input = new SADLDescription.Input(GenericInputTypes.GENERIC, SADLDescription.Name.createName(fieldName), true, false);
                return input;
            }
            return null;
        }

        public static SADLDescription.Output createOutput(ACDParameter param) {
            String fieldType = param.getType();
            Integer type = ACDParameter.detectParameterGroup(fieldType.toLowerCase());
            if (!param.isAdvanced().booleanValue()) {
                if (type == ACDParameter.PARAM_GROUP_OUTPUT) {
                    return new SADLDescription.Output(SADLDescription.Name.createName(param.getOutputFilename(true)), param.isRequired() == false);
                }
                if (type == ACDParameter.PARAM_GROUP_GRAPHICS) {
                    return new SADLDescription.Output(param.getGraphicsName(), param.isRequired() == false);
                }
            }
            return null;
        }
    }
}

