/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisTestBase;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.RemoteServiceAccessor;
import fi.csc.microarray.client.ServiceAccessor;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.operation.parameter.DataSelectionParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.session.SessionManager;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.messaging.MessagingTestBase;
import fi.csc.microarray.module.ModuleManager;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class SessionReplayTest
extends MessagingTestBase {
    private static final String FLAG_FILE = "test-ok";
    private static final String DEFAULT_SESSIONS_DIR = "sessions";
    private static final String DEFAULT_WEB_DIR = "web";
    private static final String SCREEN_OUTPUTS_DIR = "screen-outputs";
    private static final long TOOL_TEST_TIMEOUT = 3L;
    private static final TimeUnit TOOL_TEST_TIMEOUT_UNIT = TimeUnit.HOURS;
    private static final boolean FAIL_ON_OUTPUT_SIZE_MISMATCH = false;
    private static final boolean CHECK_CONTENTS = true;
    private static final String CSS = "<style type=\"text/css\">th {text-align: left; border-bottom-width: 1; border-bottom-style: solid}td {padding-right: 1em}h3 {margin-top: 2em}a {text-decoration: none}</style>";
    private Date startTime;
    private File sessionsDir;
    private static File webDir;
    private List<ToolTestResult> toolTestResults = new LinkedList<ToolTestResult>();
    private LinkedHashMap<File, Throwable> sessionsWithErrors = new LinkedHashMap();
    private LinkedHashMap<File, String> sessionsWithMissingTools = new LinkedHashMap();
    private TaskExecutor executor;
    private DataManager manager;
    private DataManager sourceManager;
    private ServiceAccessor serviceAccessor;
    LinkedList<ToolModule> toolModules;

    public SessionReplayTest(String username, String password, String configURL) {
        super(username, password, configURL);
        this.startTime = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testSessions(String sessionsDirName) throws Exception {
        this.sessionsDir = new File(sessionsDirName);
        ModuleManager moduleManager = new ModuleManager("fi.csc.microarray.module.chipster.MicroarrayModule");
        Session.getSession().setModuleManager(moduleManager);
        try {
            this.manager = new DataManager();
            moduleManager.plugAll(this.manager, null);
            this.executor = new TaskExecutor(this.endpoint, this.manager);
            this.toolModules = new LinkedList();
            this.serviceAccessor = new RemoteServiceAccessor();
            this.serviceAccessor.initialise(this.manager, this.authenticationListener);
            this.serviceAccessor.fetchDescriptions(new MicroarrayModule());
            Session.getSession().setServiceAccessor(this.serviceAccessor);
            this.toolModules.addAll(this.serviceAccessor.getModules());
            Session.getSession().setClientApplication(new SessionLoadingSkeletonApplication(this, this.toolModules, this.manager));
            this.sourceManager = new DataManager();
            moduleManager.plugAll(this.sourceManager, null);
            for (File testSession : this.sessionsDir.listFiles()) {
                if (!testSession.getName().endsWith(".zip")) continue;
                this.manager.deleteAllDataItems();
                this.sourceManager.deleteAllDataItems();
                try {
                    this.testSession(testSession);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.sessionsWithErrors.put(testSession, e);
                }
            }
        }
        finally {
            if (this.serviceAccessor != null) {
                this.serviceAccessor.close();
            }
        }
        this.createReports();
        boolean combinedToolsResult = true;
        for (ToolTestResult toolTestResult : this.toolTestResults) {
            if (!toolTestResult.getTestResult().equals((Object)TestResult.FAIL)) continue;
            combinedToolsResult = false;
        }
        if (!combinedToolsResult) {
            System.out.println("failed tools, failing");
            return false;
        }
        if (this.toolTestResults.size() == 0) {
            System.out.println("zero results, failing");
            return false;
        }
        if (this.sessionsWithMissingTools.size() > 0) {
            System.out.println("missing tools, failing");
            return false;
        }
        if (this.sessionsWithErrors.size() > 0) {
            System.out.println("sessions with errors, failing");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSession(File session) throws Exception {
        HashMap<DataBean, DataBean> sourceDataBeanToTargetDataBean = new HashMap<DataBean, DataBean>();
        Session.getSession().setDataManager(this.sourceManager);
        SessionManager sourceSessionManager = new SessionManager(this.sourceManager, this.serviceAccessor.getFileBrokerClient(), null);
        sourceSessionManager.loadLocalSession(session, false);
        Session.getSession().setDataManager(this.manager);
        LinkedList<OperationRecord> rootLevelOperationRecords = new LinkedList<OperationRecord>();
        HashMap<OperationRecord, LinkedList<DataBean>> outputMap = new HashMap<OperationRecord, LinkedList<DataBean>>();
        LinkedList<DataBean> dataBeansInSourceManagerWhichWereCopied = new LinkedList<DataBean>();
        for (DataBean dataBean : this.sourceManager.databeans()) {
            LinkedList<DataBean> outputs;
            OperationRecord operationRecord = dataBean.getOperationRecord();
            if ("operation-definition-id-import".equals(operationRecord.getNameID().getID()) || "LocalNGSPreprocess.java".equals(operationRecord.getNameID().getID()) || dataBean.getLinkTargets(DataBean.Link.derivationalTypes()).size() == 0 && operationRecord.getInputs().size() > 0) {
                DataBean dataBeanCopy = this.manager.createDataBean(dataBean.getName());
                URL urlInSessionZip = null;
                for (DataManager.ContentLocation contentLocation : this.sourceManager.getContentLocationsForDataBeanSaving(dataBean)) {
                    if (contentLocation.getMethod() != DataManager.StorageMethod.LOCAL_SESSION_ZIP) continue;
                    urlInSessionZip = contentLocation.getUrl();
                }
                if (urlInSessionZip == null) {
                    throw new IllegalArgumentException("session file " + session.getName() + " must contain all data files (missing " + dataBean.getName() + ")");
                }
                URL url = new URL(session.toURI().toURL(), "#" + urlInSessionZip.getRef());
                this.manager.addContentLocationForDataBean(dataBeanCopy, DataManager.StorageMethod.LOCAL_SESSION_ZIP, url);
                sourceDataBeanToTargetDataBean.put(dataBean, dataBeanCopy);
                dataBeansInSourceManagerWhichWereCopied.add(dataBean);
                dataBeanCopy.setOperationRecord(operationRecord);
                this.manager.connectChild(dataBeanCopy, this.manager.getRootFolder());
                rootLevelOperationRecords.add(operationRecord);
            }
            if ((outputs = (LinkedList<DataBean>)outputMap.get(operationRecord)) != null) {
                outputs.add(dataBean);
                continue;
            }
            outputs = new LinkedList<DataBean>();
            outputs.add(dataBean);
            outputMap.put(operationRecord, outputs);
        }
        for (DataBean originalBean : dataBeansInSourceManagerWhichWereCopied) {
            for (DataBean.Link linkType : DataBean.Link.values()) {
                for (DataBean originalLinkSourceBean : originalBean.getLinkSources(linkType)) {
                    if (!dataBeansInSourceManagerWhichWereCopied.contains(originalLinkSourceBean)) continue;
                    ((DataBean)sourceDataBeanToTargetDataBean.get(originalLinkSourceBean)).addLink(linkType, (DataBean)sourceDataBeanToTargetDataBean.get(originalBean));
                }
            }
        }
        LinkedList<OperationRecord> operationRecords = new LinkedList<OperationRecord>();
        for (DataBean dataBean : this.sourceManager.databeans()) {
            OperationRecord operationRecord = dataBean.getOperationRecord();
            if (operationRecords.contains(operationRecord)) continue;
            operationRecords.add(operationRecord);
        }
        for (OperationRecord operationRecord : operationRecords) {
            if (rootLevelOperationRecords.contains(operationRecord)) {
                System.out.println("skipping root level operation " + operationRecord.getFullName());
                continue;
            }
            System.out.println("setting up " + operationRecord.getFullName());
            LinkedList<DataBean> inputBeans = new LinkedList<DataBean>();
            for (OperationRecord.InputRecord inputRecord : operationRecord.getInputs()) {
                DataBean inputBean = (DataBean)sourceDataBeanToTargetDataBean.get(inputRecord.getValue());
                if (inputBean != null) {
                    inputBeans.add(inputBean);
                    continue;
                }
                String s = "not enough inputs for " + operationRecord.getFullName();
                System.out.println(s);
                throw new RuntimeException(s);
            }
            OperationDefinition operationDefinition = this.getOperationDefinition(operationRecord.getNameID().getID(), this.toolModules);
            if (operationDefinition == null) {
                System.out.println("Missing tool: " + operationRecord.getNameID().getID() + "  in session: " + session.getName() + " skipping rest of the session");
                this.sessionsWithMissingTools.put(session, operationRecord.getNameID().getID());
                return;
            }
            Operation operation = new Operation(operationDefinition, inputBeans.toArray(new DataBean[0]));
            for (OperationRecord.ParameterRecord parameterRecord : operationRecord.getParameters()) {
                Parameter definitionParameter;
                if (parameterRecord.getValue() == null || parameterRecord.getValue().equals("") || (definitionParameter = operation.getDefinition().getParameter(parameterRecord.getNameID().getID())) == null) continue;
                Parameter parameter = (Parameter)definitionParameter.clone();
                if (parameter instanceof DataSelectionParameter) {
                    ((DataSelectionParameter)parameter).parseValueAndSetWithoutChecks(parameterRecord.getValue());
                } else {
                    parameter.parseValue(parameterRecord.getValue());
                }
                operation.setParameter(parameter.getID(), parameter.getValue());
            }
            Task task = this.executor.createTask(operation);
            System.out.println("running " + operation.getDefinition().getFullName());
            CountDownLatch latch = new CountDownLatch(1);
            task.addTaskEventListener(new AnalysisTestBase.JobResultListener(latch));
            this.executor.startExecuting(task);
            latch.await(3L, TOOL_TEST_TIMEOUT_UNIT);
            if (!task.getState().equals((Object)Task.State.COMPLETED)) {
                if (task.getState().equals((Object)Task.State.RUNNING)) {
                    this.executor.kill(task);
                    this.toolTestResults.add(new ToolTestResult(TestResult.FAIL, operation, session, task, "task did not finish before test timeout 3 " + TOOL_TEST_TIMEOUT_UNIT.toString()));
                    return;
                }
                this.toolTestResults.add(new ToolTestResult(TestResult.FAIL, operation, session, task, "task was not completed"));
                return;
            }
            Session.getSession().setDataManager(this.manager);
            try {
                DataBean targetBean;
                Session.getSession().getApplication().onFinishedTask(task, operation, task.getState());
                Iterator<DataBean> targetIterator = task.outputs().iterator();
                for (DataBean sourceBean : (List)outputMap.get(operationRecord)) {
                    if (targetIterator.hasNext()) {
                        targetBean = targetIterator.next();
                        if (sourceBean.getContentType().getType().equals(targetBean.getContentType().getType())) continue;
                        this.toolTestResults.add(new ToolTestResult(TestResult.FAIL, operation, session, task, "Mismatch in result content types, " + sourceBean.getName() + ": " + sourceBean.getContentType().getType() + ", " + targetBean.getName() + ": " + targetBean.getContentType().getType()));
                        return;
                    }
                    this.toolTestResults.add(new ToolTestResult(TestResult.FAIL, operation, session, task, "not enough result datasets"));
                    return;
                }
                if (targetIterator.hasNext()) {
                    this.toolTestResults.add(new ToolTestResult(TestResult.FAIL, operation, session, task, "too many result datasets"));
                    return;
                }
                targetIterator = task.outputs().iterator();
                for (DataBean sourceBean : (List)outputMap.get(operationRecord)) {
                    targetBean = targetIterator.next();
                    if (!Session.getSession().getPrimaryModule().isMetadata(targetBean)) continue;
                    System.out.println("copying metadata for: " + targetBean.getName());
                    OutputStream metadataOut = this.manager.getContentOutputStreamAndLockDataBean(targetBean);
                    ChecksumInputStream sourceIn = null;
                    try {
                        sourceIn = this.sourceManager.getContentStream(sourceBean, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA);
                        IOUtils.copy((InputStream)sourceIn, metadataOut);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeIfPossible(sourceIn);
                        this.manager.closeContentOutputStreamAndUnlockDataBean(targetBean, metadataOut);
                        throw throwable;
                    }
                    IOUtils.closeIfPossible(sourceIn);
                    this.manager.closeContentOutputStreamAndUnlockDataBean(targetBean, metadataOut);
                }
                LinkedList<String> outputsWithMisMatchingSizes = new LinkedList<String>();
                LinkedList<String> outputsWithMisMatchingContents = new LinkedList<String>();
                targetIterator = task.outputs().iterator();
                for (DataBean sourceBean : (List)outputMap.get(operationRecord)) {
                    ChecksumInputStream targetIn;
                    ChecksumInputStream sourceIn;
                    block41: {
                        DataBean targetBean2 = targetIterator.next();
                        try {
                            this.compareDataBeans(sourceBean, targetBean2);
                        }
                        catch (Throwable t) {
                            this.toolTestResults.add(new ToolTestResult(TestResult.FAIL, operation, session, task, t.getMessage()));
                            Session.getSession().setDataManager(null);
                            return;
                        }
                        sourceDataBeanToTargetDataBean.put(sourceBean, targetBean2);
                        if (Session.getSession().getDataManager().getContentLength(sourceBean) != Session.getSession().getDataManager().getContentLength(targetBean2)) {
                            if (sourceBean.getName().equals(targetBean2.getName())) {
                                outputsWithMisMatchingSizes.add(sourceBean.getName());
                            } else {
                                outputsWithMisMatchingSizes.add(sourceBean.getName() + " | " + targetBean2.getName());
                            }
                        }
                        sourceIn = null;
                        targetIn = null;
                        try {
                            sourceIn = this.sourceManager.getContentStream(sourceBean, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA);
                            targetIn = this.manager.getContentStream(targetBean2, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA);
                            if (IOUtils.contentEquals(sourceIn, targetIn)) break block41;
                            if (sourceBean.getName().equals(targetBean2.getName())) {
                                outputsWithMisMatchingContents.add(sourceBean.getName());
                                break block41;
                            }
                            outputsWithMisMatchingContents.add(sourceBean.getName() + " | " + targetBean2.getName());
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeIfPossible(sourceIn);
                            IOUtils.closeIfPossible(targetIn);
                            throw throwable;
                        }
                    }
                    IOUtils.closeIfPossible(sourceIn);
                    IOUtils.closeIfPossible(targetIn);
                }
                ToolTestResult toolTestResult = new ToolTestResult(TestResult.OK, operation, session, task, null);
                toolTestResult.setOutputsWithMisMatchingSizes(outputsWithMisMatchingSizes);
                toolTestResult.setOutputsWithMisMatchingContents(outputsWithMisMatchingContents);
                this.toolTestResults.add(toolTestResult);
            }
            finally {
                Session.getSession().setDataManager(null);
            }
        }
    }

    private OperationDefinition getOperationDefinition(String toolId, LinkedList<ToolModule> toolModules) {
        for (ToolModule module : toolModules) {
            OperationDefinition tool = module.getOperationDefinition(toolId);
            if (tool == null) continue;
            return tool;
        }
        return null;
    }

    private void compareDataBeans(DataBean bean1, DataBean bean2) {
        Assert.assertEquals((Object)bean1.getContentType().getType(), (Object)bean2.getContentType().getType());
        if (Session.getSession().getDataManager().getContentLength(bean1) > 0L) {
            Assert.assertTrue((String)"zero size dataset", (Session.getSession().getDataManager().getContentLength(bean2) > 0L ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean testOK = false;
        webDir = new File(DEFAULT_WEB_DIR);
        try {
            String configURL = null;
            String username = null;
            String password = null;
            String sessionsDirName = DEFAULT_SESSIONS_DIR;
            switch (args.length) {
                case 3: {
                    configURL = args[0];
                    username = args[1];
                    password = args[2];
                    DirectoryLayout.initialiseClientLayout(configURL);
                    break;
                }
                case 4: {
                    configURL = args[0];
                    username = args[1];
                    password = args[2];
                    DirectoryLayout.initialiseClientLayout(configURL);
                    sessionsDirName = args[3];
                    break;
                }
                case 5: {
                    configURL = args[0];
                    username = args[1];
                    password = args[2];
                    DirectoryLayout.initialiseClientLayout(configURL);
                    sessionsDirName = args[3];
                    webDir = new File(args[4]);
                    break;
                }
                default: {
                    System.out.println("Usage: " + SessionReplayTest.class.getSimpleName() + " <config-url username password> <sessions dir> <web dir>\n" + "If there are no arguments, config file is used.");
                    SessionReplayTest.updateFlagFileAndExit(false);
                }
            }
            SessionReplayTest test = null;
            try {
                test = new SessionReplayTest(username, password, configURL);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("TOOL TESTS INIT ERROR");
                SessionReplayTest.updateFlagFileAndExit(false);
            }
            try {
                test.setUp();
                testOK = test.testSessions(sessionsDirName);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("TOOL TEST ERROR");
                test.tearDown();
                SessionReplayTest.updateFlagFileAndExit(false);
            }
            finally {
                test.tearDown();
            }
            if (testOK) {
                System.out.println("TOOL TESTS OK");
                SessionReplayTest.updateFlagFileAndExit(true);
            } else {
                System.out.println("TOOL TESTS FAILED");
                SessionReplayTest.updateFlagFileAndExit(false);
            }
        }
        finally {
            SessionReplayTest.updateFlagFileAndExit(false);
        }
    }

    private void createReports() throws IOException {
        final HashMap<String, Integer> uniqueTools = new HashMap<String, Integer>();
        HashMap<String, Integer> failCounts = new HashMap<String, Integer>();
        HashSet<File> uniqueSessions = new HashSet<File>();
        HashMap<String, List<File>> toolToSessionsMap = new HashMap<String, List<File>>();
        for (ToolTestResult toolTestResult : this.toolTestResults) {
            List<File> sessionsList;
            if (!uniqueTools.containsKey(toolTestResult.getOperation().getID())) {
                uniqueTools.put(toolTestResult.getOperation().getID(), 1);
            } else {
                uniqueTools.put(toolTestResult.getOperation().getID(), (Integer)uniqueTools.get(toolTestResult.getOperation().getID()) + 1);
            }
            if (!toolToSessionsMap.containsKey(toolTestResult.getOperation().getID())) {
                sessionsList = new LinkedList<File>();
                sessionsList.add(toolTestResult.getSession());
                toolToSessionsMap.put(toolTestResult.getOperation().getID(), sessionsList);
            } else {
                sessionsList = (List)toolToSessionsMap.get(toolTestResult.getOperation().getID());
                if (!sessionsList.contains(toolTestResult.getSession())) {
                    sessionsList.add(toolTestResult.getSession());
                }
            }
            if (uniqueSessions.contains(toolTestResult.getSession())) continue;
            uniqueSessions.add(toolTestResult.getSession());
        }
        String[] toolsSortedbyTestCount = uniqueTools.keySet().toArray(new String[0]);
        Arrays.sort(toolsSortedbyTestCount, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return (Integer)uniqueTools.get(arg1) - (Integer)uniqueTools.get(arg0);
            }
        });
        LinkedList<ToolTestResult> failedTasks = new LinkedList<ToolTestResult>();
        LinkedList<ToolTestResult> successTasks = new LinkedList<ToolTestResult>();
        for (ToolTestResult toolTestResult : this.toolTestResults) {
            if (TestResult.FAIL.equals((Object)toolTestResult.getTestResult())) {
                failedTasks.add(toolTestResult);
                String toolID = toolTestResult.getOperation().getID();
                if (failCounts.containsKey(toolID)) {
                    failCounts.put(toolID, (Integer)failCounts.get(toolID) + 1);
                    continue;
                }
                failCounts.put(toolID, 1);
                continue;
            }
            successTasks.add(toolTestResult);
        }
        webDir.mkdirs();
        File screenOutputsDir = new File(webDir, SCREEN_OUTPUTS_DIR);
        if (screenOutputsDir.exists()) {
            for (File f : screenOutputsDir.listFiles()) {
                f.delete();
            }
        }
        File htmlFile = new File(webDir, "index.html");
        FileWriter writer = new FileWriter(htmlFile);
        writer.write("<html>");
        writer.write("<head><style type=\"text/css\">th {text-align: left; border-bottom-width: 1; border-bottom-style: solid}td {padding-right: 1em}h3 {margin-top: 2em}a {text-decoration: none}</style></head>");
        writer.write("<body>");
        String titleStatus = "<span style=\"color: green\">everything ok!</span>";
        if (failedTasks.size() > 0 || this.sessionsWithErrors.size() > 0 || this.sessionsWithMissingTools.size() > 0) {
            titleStatus = "<span style=\"color: red\">" + failCounts.keySet().size() + " tool(s) failed in " + failedTasks.size() + " test(s), " + this.sessionsWithErrors.size() + " session(s) with errors, " + this.sessionsWithMissingTools.size() + " sessions(s) with missing tools" + "</span>";
        }
        writer.write("<h2>Tool tests &ndash; " + titleStatus + "</h2>");
        writer.write("<h3>Summary</h3>");
        long duration = (System.currentTimeMillis() - this.startTime.getTime()) / 1000L;
        String totalTime = String.format("%02dm %02ds", duration / 60L, duration % 60L);
        writer.write("<table><tr><td>Results summary</td><td>" + successTasks.size() + " <span" + (successTasks.isEmpty() ? "" : " style=\"color: green\"") + ">ok</span>, " + failedTasks.size() + " <span" + (failedTasks.isEmpty() ? "" : " style=\"color: red\"") + ">failed</span>, " + this.toolTestResults.size() + " total</td</tr>" + "<tr><td>Tool coverage</td><td>" + uniqueTools.size() + "/" + this.getTotalNumberOfTools() + "</td></tr>" + "<tr><td>Sessions</td>" + "<td>" + uniqueSessions.size() + " total, " + this.sessionsWithErrors.size() + " <span" + (this.sessionsWithErrors.isEmpty() ? "" : " style=\"color: red\"") + ">with errors</span>, " + this.sessionsWithMissingTools.size() + " <span" + (this.sessionsWithMissingTools.isEmpty() ? "" : " style=\"color: red\"") + ">with missing tools</span>, " + "</td></tr>" + "<tr><td>Start time</td><td>" + this.startTime.toString() + "</td></tr>" + "<tr><td>Total time</td><td>" + totalTime + "</td></tr>" + "</table>");
        if (this.sessionsWithErrors.size() > 0) {
            writer.write("<h3>Sessions with errors</h3>");
            writer.write("<table><tr><th>Session</th><th>Throwable</th></tr>");
            for (Map.Entry<File, Throwable> entry : this.sessionsWithErrors.entrySet()) {
                writer.write("<tr><td>" + entry.getKey().getName() + "</td>" + "<td>" + entry.getValue().toString() + "</td>" + "</tr>");
            }
            writer.write("</table>");
        }
        if (this.sessionsWithMissingTools.size() > 0) {
            writer.write("<h3>Sessions with missing tools</h3>");
            writer.write("<table><tr><th>Session</th><th>Tool</th></tr>");
            for (Map.Entry<File, Object> entry : this.sessionsWithMissingTools.entrySet()) {
                writer.write("<tr><td>" + entry.getKey().getName() + "</td>" + "<td>" + (String)entry.getValue() + "</td>" + "</tr>");
            }
            writer.write("</table>");
        }
        writer.write("<h3>Tool test results</h3>");
        writer.write("<table><tr><th>Tool</th><th>Result</th><th>Session</th><th>Task state</th><th>Test error message</th><th>Task error message</th><th>Task screen output</th><th>Duration</th><th>Outputs with mismatching sizes</th><th>Outputs with mismatching contents</th></tr>");
        for (ToolTestResult toolTestResult : failedTasks) {
            writer.write("<tr><td>" + toolTestResult.getOperation().getDefinition().getFullName() + "</td>" + "<td style=\"color: red\">" + (Object)((Object)toolTestResult.getTestResult()) + "</td>" + "<td>" + this.createSessionLink(toolTestResult.getSession()) + "</td>" + "<td>" + (Object)((Object)toolTestResult.getTask().getState()) + "</td>" + "<td>" + this.nullToEmpty(toolTestResult.getTestErrorMessage()) + "</td>" + "<td>" + this.nullToEmpty(toolTestResult.getTask().getErrorMessage()) + "</td>" + "<td>" + this.createScreenOutputLink(toolTestResult.getTask()) + "</td>" + "<td><nobr>" + this.getDurationString(toolTestResult.getTask()) + "</nobr></td>" + "<td>" + this.getOutputsWithMisMatchingSizes(toolTestResult) + "</td>" + "<td>" + this.getOutputsWithMisMatchingContents(toolTestResult) + "</td>" + "</tr>");
        }
        for (ToolTestResult toolTestResult : successTasks) {
            writer.write("<tr><td>" + toolTestResult.getOperation().getDefinition().getFullName() + "</td>" + "<td>" + (Object)((Object)toolTestResult.getTestResult()) + "</td>" + "<td>" + this.createSessionLink(toolTestResult.getSession()) + "</td>" + "<td>" + (Object)((Object)toolTestResult.getTask().getState()) + "</td>" + "<td>" + this.nullToEmpty(toolTestResult.getTestErrorMessage()) + "</td>" + "<td>" + this.nullToEmpty(toolTestResult.getTask().getErrorMessage()) + "</td>" + "<td>" + this.createScreenOutputLink(toolTestResult.getTask()) + "</td>" + "<td><nobr>" + this.getDurationString(toolTestResult.getTask()) + "</nobr></td>" + "<td>" + this.getOutputsWithMisMatchingSizes(toolTestResult) + "</td>" + "<td>" + this.getOutputsWithMisMatchingContents(toolTestResult) + "</td>" + "</tr>");
        }
        writer.write("</table>");
        writer.write("<h3>Coverage</h3>");
        writer.write("<table><tr><th>Tool</th><th>Count</th><th>Sessions</th></tr>");
        for (String toolID : toolsSortedbyTestCount) {
            String sessionsString = "";
            for (File session : (List)toolToSessionsMap.get(toolID)) {
                sessionsString = sessionsString + this.createSessionLink(session) + " ";
            }
            sessionsString.trim();
            writer.write("<tr><td>" + this.getOperationDefinition(toolID, this.toolModules).getFullName() + "</td>" + "<td>" + uniqueTools.get(toolID) + "</td>" + "<td>" + sessionsString + "</td>" + "</tr>");
        }
        for (OperationDefinition operationDefinition : this.getAllOperationDefinitions()) {
            if (uniqueTools.containsKey(operationDefinition.getID())) continue;
            writer.write("<tr><td>" + operationDefinition.getFullName() + "</td>" + "<td>" + 0 + "</td>" + "<td>" + "" + "</td>" + "</tr>");
        }
        writer.write("</table>");
        writer.write("</body></html>");
        writer.flush();
        writer.close();
    }

    private String getOutputsWithMisMatchingSizes(ToolTestResult toolTestResult) {
        String s = "";
        for (String output : toolTestResult.getOutputsWithMisMatchingSizes()) {
            s = s + output + ", ";
        }
        if (s.endsWith(", ")) {
            s = s.substring(0, s.length() - ", ".length());
        }
        return s;
    }

    private String getOutputsWithMisMatchingContents(ToolTestResult toolTestResult) {
        String s = "";
        for (String output : toolTestResult.getOutputsWithMisMatchingContents()) {
            s = s + output + ", ";
        }
        if (s.endsWith(", ")) {
            s = s.substring(0, s.length() - ", ".length());
        }
        return s;
    }

    private static void updateFlagFileAndExit(boolean testOK) throws IOException {
        File flagFile = new File(webDir, FLAG_FILE);
        if (testOK) {
            if (!flagFile.exists()) {
                flagFile.createNewFile();
            } else {
                flagFile.setLastModified(System.currentTimeMillis());
            }
        } else {
            flagFile.delete();
        }
        if (testOK) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private int getTotalNumberOfTools() {
        HashSet<String> uniqueIDs = new HashSet<String>();
        for (ToolModule toolModule : this.toolModules) {
            for (ToolCategory toolCategory : toolModule.getVisibleCategories()) {
                for (OperationDefinition od : toolCategory.getToolList()) {
                    if (uniqueIDs.contains(od.getID())) continue;
                    uniqueIDs.add(od.getID());
                }
            }
        }
        return uniqueIDs.size();
    }

    private List<OperationDefinition> getAllOperationDefinitions() {
        LinkedList<OperationDefinition> tools = new LinkedList<OperationDefinition>();
        for (ToolModule toolModule : this.toolModules) {
            for (ToolCategory toolCategory : toolModule.getVisibleCategories()) {
                for (OperationDefinition od : toolCategory.getToolList()) {
                    tools.add(od);
                }
            }
        }
        return tools;
    }

    private String nullToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private String createSessionLink(File sessionFile) {
        return "<a href=\"" + this.sessionsDir + "/" + sessionFile.getName() + "\">" + sessionFile.getName() + "</a>";
    }

    private String createScreenOutputLink(Task task) {
        if (task.getScreenOutput() == null) {
            return "";
        }
        File outputsDir = new File(webDir, SCREEN_OUTPUTS_DIR);
        outputsDir.mkdirs();
        File outputFile = new File(outputsDir, task.getId() + "-output");
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(task.getScreenOutput().getBytes()), outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "creating screen output failed";
        }
        return "<a href=\"screen-outputs/" + outputFile.getName() + "\">" + "output" + "</a>";
    }

    private String getDurationString(Task task) {
        long duration = task.getExecutionTime() / 1000L;
        return String.format("%02dm %02ds", duration / 60L, duration % 60L);
    }

    public static class SessionLoadingSkeletonApplication
    extends ClientApplication {
        private SessionReplayTest parent;

        public SessionLoadingSkeletonApplication(SessionReplayTest parent, LinkedList<ToolModule> toolModules, DataManager manager) {
            this.parent = parent;
            this.toolModules = toolModules;
            this.manager = manager;
            logger = Logger.getLogger(SessionLoadingSkeletonApplication.class);
        }

        @Override
        public OperationDefinition getOperationDefinition(String toolId) {
            return this.parent.getOperationDefinition(toolId, this.toolModules);
        }

        @Override
        public void initialiseGUIThreadSafely(File session) throws MicroarrayException, IOException {
            throw new UnsupportedOperationException("not supported by skeleton app");
        }

        @Override
        public void reportException(Exception e) {
            throw new UnsupportedOperationException("not supported by skeleton app");
        }

        @Override
        public void reportInitialisationThreadSafely(String report, boolean newline) {
            throw new UnsupportedOperationException("not supported by skeleton app");
        }

        @Override
        public void reportTaskError(Task job) throws MicroarrayException {
            throw new UnsupportedOperationException("not supported by skeleton app");
        }

        @Override
        public void runBlockingTask(String taskName, Runnable runnable) {
            throw new UnsupportedOperationException("not supported by skeleton app");
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal) {
            this.showDialog(title, message, details, severity, modal, ChipsterDialog.DetailsVisibility.DETAILS_VISIBLE, null);
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility, ChipsterDialog.PluginButton button) {
            this.showDialog(title, message, details, severity, modal, detailsVisibility, button, false);
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility, ChipsterDialog.PluginButton button, boolean feedBackEnabled) {
            System.out.println(title + "\n" + message + "\n" + details);
        }

        @Override
        public void reportExceptionThreadSafely(Exception e) {
            throw new UnsupportedOperationException("not supported by skeleton app");
        }
    }

    private class ToolTestResult {
        private TestResult testResult;
        private Operation operation;
        private File sessionFile;
        private Task task;
        private String testErrorMessage;
        private List<String> outputsWithMisMatchingSizes = new LinkedList<String>();
        private List<String> outputsWithMisMatchingContents = new LinkedList<String>();

        public ToolTestResult(TestResult testResult, Operation operation, File sessionFile, Task task, String testErrorMessage) {
            this.testResult = testResult;
            this.operation = operation;
            this.sessionFile = sessionFile;
            this.task = task;
            this.testErrorMessage = testErrorMessage;
        }

        public TestResult getTestResult() {
            return this.testResult;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public File getSession() {
            return this.sessionFile;
        }

        public Task getTask() {
            return this.task;
        }

        public String getTestErrorMessage() {
            return this.testErrorMessage;
        }

        public List<String> getOutputsWithMisMatchingSizes() {
            return this.outputsWithMisMatchingSizes;
        }

        public void setOutputsWithMisMatchingSizes(List<String> outputs) {
            this.outputsWithMisMatchingSizes = outputs;
        }

        public List<String> getOutputsWithMisMatchingContents() {
            return this.outputsWithMisMatchingContents;
        }

        public void setOutputsWithMisMatchingContents(List<String> outputs) {
            this.outputsWithMisMatchingContents = outputs;
        }
    }

    private static enum TestResult {
        OK,
        FAIL;

    }
}

