/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskEventListener;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.messaging.MessagingTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class AnalysisTestBase
extends MessagingTestBase {
    protected DataManager manager;
    protected TaskExecutor executor;

    public AnalysisTestBase() {
    }

    public AnalysisTestBase(String username, String password) {
        super(username, password);
    }

    public AnalysisTestBase(String username, String password, String configURL) {
        super(username, password, configURL);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.manager = new DataManager();
        this.executor = new TaskExecutor(this.endpoint, this.manager);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected void executeJob(Task job) throws TaskException, InterruptedException {
        this.executeJob(job, 60000L, TimeUnit.MILLISECONDS, Task.State.COMPLETED);
    }

    protected void executeJob(Task job, long timeout, TimeUnit timeUnit) throws TaskException, InterruptedException {
        this.executeJob(job, timeout, timeUnit, Task.State.COMPLETED);
    }

    protected void executeJob(Task job, Task.State expectedEndState) throws TaskException, InterruptedException {
        this.executeJob(job, 60000L, TimeUnit.MILLISECONDS, expectedEndState);
    }

    protected void executeJob(Task job, long timeout, TimeUnit timeUnit, Task.State expectedEndState) throws TaskException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        job.addTaskEventListener(new JobResultListener(latch));
        this.executor.startExecuting(job);
        latch.await(timeout, timeUnit);
        Task.State endState = job.getState();
        Assert.assertEquals((Object)((Object)endState), (Object)((Object)expectedEndState));
    }

    public static class JobResultListener
    implements TaskEventListener {
        private CountDownLatch latch;

        public JobResultListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void onStateChange(Task job, Task.State oldState, Task.State newState) {
            if (newState.isFinished()) {
                this.latch.countDown();
            }
        }
    }
}

