/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.ModuleManager;
import java.io.File;
import java.io.IOException;

public class ClientContextUtil {
    public static void setupClientContext() throws Exception {
        DirectoryLayout.uninitialise();
        DirectoryLayout.initialiseSimpleLayout().getConfiguration();
        DataManager manager = new DataManager();
        Session.getSession().setDataManager(manager);
        ModuleManager moduleManager = new ModuleManager("fi.csc.microarray.module.chipster.MicroarrayModule");
        moduleManager.plugAll(manager, Session.getSession());
        Session.getSession().setModuleManager(moduleManager);
        Session.getSession().setClientApplication(new SkeletonApplication());
    }

    public static void setupDatabean(DataBean data) throws MicroarrayException {
        data.setContentType(new ContentType("", false, false, "", null, ""));
        OperationRecord operationRecord = new OperationRecord(new Operation(new OperationDefinition("", "", new ToolCategory(""), "", false), new DataBean[]{data}));
        data.setOperationRecord(operationRecord);
        operationRecord.setModule("");
    }

    private static class SkeletonApplication
    extends ClientApplication {
        private SkeletonApplication() {
        }

        @Override
        public void initialiseGUIThreadSafely(File backupSession) throws MicroarrayException, IOException {
        }

        @Override
        public void reportException(Exception e) {
        }

        @Override
        public void reportTaskError(Task job) throws MicroarrayException {
        }

        @Override
        public void reportInitialisationThreadSafely(String report, boolean newline) {
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal) {
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility, ChipsterDialog.PluginButton button) {
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility, ChipsterDialog.PluginButton button, boolean feedBackEnabled) {
        }

        @Override
        public void runBlockingTask(String taskName, Runnable runnable) {
        }

        @Override
        public DataManager getDataManager() {
            return null;
        }

        @Override
        public void reportExceptionThreadSafely(Exception e) {
        }
    }
}

