/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Node;

@XmlRootElement(name="tidyMarkup")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TidyMarkupDataFormat
extends DataFormatDefinition {
    @XmlAttribute(name="dataObjectType")
    private String dataObjectTypeName;
    @XmlTransient
    private Class<?> dataObjectType;

    public TidyMarkupDataFormat() {
        super("tidyMarkup");
        this.setDataObjectType(Node.class);
    }

    public TidyMarkupDataFormat(Class<?> dataObjectType) {
        this();
        if (!dataObjectType.isAssignableFrom(String.class) && !dataObjectType.isAssignableFrom(Node.class)) {
            throw new IllegalArgumentException("TidyMarkupDataFormat only supports returning a String or a org.w3c.dom.Node object");
        }
        this.setDataObjectType(dataObjectType);
    }

    public void setDataObjectType(Class<?> dataObjectType) {
        this.dataObjectType = dataObjectType;
    }

    public Class<?> getDataObjectType() {
        return this.dataObjectType;
    }

    public String getDataObjectTypeName() {
        return this.dataObjectTypeName;
    }

    public void setDataObjectTypeName(String dataObjectTypeName) {
        this.dataObjectTypeName = dataObjectTypeName;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.dataObjectType == null && this.dataObjectTypeName != null) {
            try {
                this.dataObjectType = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.dataObjectTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createDataFormat(routeContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.dataObjectType != null) {
            this.setProperty(camelContext, dataFormat, "dataObjectType", this.dataObjectType);
        }
    }
}

